<?php

namespace Adfox\Watermark\Filament\Pages;

use App\Models\SettingsProperty;
use App\Settings\WatermarkSettings;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\SpatieMediaLibraryFileUpload;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;

class ManageWatermarkSettings extends SettingsPage
{
    protected static ?string $title = 'Watermark Settings';

    protected static ?string $navigationGroup = 'Settings';

    protected static ?string $navigationLabel = 'Watermark';

    protected static ?string $slug = 'manage-watermark-settings';

    protected static ?int $navigationSort = 7;

    protected static string $settings = WatermarkSettings::class;


    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Toggle::make('enable_watermark')
                    ->label('Enable Watermark')
                    ->helperText('Toggle to activate or deactivate the watermark feature.'),

                Select::make('position')
                    ->label('Watermark Position')
                    ->selectablePlaceholder(false)
                    ->options([
                        'bottom-right' => 'Bottom Right',
                        'bottom-left' => 'Bottom Left',
                        'top-right' => 'Top Right',
                        'top-left' => 'Top Left',
                        'center' => 'Center',
                    ])
                    ->helperText('Specify the watermark position (e.g., "bottom-right").'),

                SpatieMediaLibraryFileUpload::make('watermark_image')
                    ->label('Watermark Image')
                    ->collection('watermark')
                    ->visibility('public')
                    ->image()
                    ->disk('media')
                    ->model(
                        SettingsProperty::getInstance('watermark.watermark_image'),
                    )
                    ->helperText('Upload the watermark image.'),
            ])
            ->columns(2);
    }
}
