<?php

namespace Adfox\VehicleRentalMarketplace;

use Filament\Navigation\NavigationGroup;
use Filament\Panel;
use Filament\Contracts\Plugin;

class VehicleRentalMarketPlacePlugin implements Plugin
{
    public function getId(): string
    {
        return 'vehicle-rental-marketplace';
    }

    public function register(Panel $panel): void
    {
        if ($panel->getId() == 'admin') {
            $panel->discoverResources(
                in: __DIR__ . '/Filament/Resources',
                for: 'Adfox\\VehicleRentalMarketplace\\Filament\\Resources'
            )->discoverPages(
                in: __DIR__ . '/Filament/Pages',
                for: 'Adfox\\VehicleRentalMarketplace\\Filament\\Pages'
            )->discoverClusters(
                in: __DIR__ . '/Filament/Clusters',
                for: 'Adfox\\VehicleRentalMarketplace\\Filament\\Clusters')
            ->navigationGroups([
                NavigationGroup::make()
                ->label('Vehicle Rental Management')
                ->icon('heroicon-o-squares-2x2')
            ]);
        }
    }

    public function boot(Panel $panel): void {}
}
