<?php

namespace Adfox\VehicleRentalMarketplace\Models;

use App\Models\Ad;

class VehicleRentalAd extends Ad
{
    protected $table = 'ads';

    protected $fillable = [
        'title',
        'description',
        'price',
        'make_id',
        'model_id',
        'availability_window',
        'min_trip_length',
        'max_trip_length',
        'transmission_id',
        'fuel_type_id',
        'mileage',
        'start_date',
        'end_date'
    ];

    public function features()
    {
        return $this->belongsToMany(VehicleFeature::class, 'ad_vehicle_feature', 'ad_id', 'vehicle_feature_id');
    }

    public function make()
    {
        return $this->belongsTo(VehicleMake::class);
    }

    public function transmission()
    {
        return $this->belongsTo(VehicleTransmission::class);
    }

    public function model(){
        return $this->belongsTo(VehicleModel::class);
    }

    public function fuelType()
    {
        return $this->belongsTo(VehicleFuelType::class);
    }
}
