<?php

namespace Adfox\VehicleRentalMarketplace\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;

class VehicleMake extends Model
{
    use HasFactory, HasTranslations;
    protected $fillable = [
        'name',
        'slug',
        'order'
    ];
    public $translatable = ['name'];
    public function vehicleRentals()
    {
        return $this->hasMany(VehicleRentalAd::class);
    }
    public function models()
    {
        return $this->hasMany(VehicleModel::class,'make_id');
    }
}
