<?php

namespace Adfox\VehicleRentalMarketplace\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;

class VehicleFeature extends Model
{
    use HasFactory,HasTranslations;
    protected $fillable=[
        'name',
        'order'
    ];
    public $translatable = ['name'];
    public function vehicleRentals(){
        return $this->belongsToMany(VehicleRentalAd::class,'vehicle_rental_feature','vehicle_feature_id','vehicle_rental_id');
    }
}
