<?php

namespace Adfox\VehicleRentalMarketplace\Models;

use App\Models\Ad;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TemproveryBookingData extends Model
{
    use HasFactory;

    protected $fillable = [
        'ad_id',
        'user_id',
        'start_date',
        'end_date',
        'days',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function ads()
    {
        return $this->belongsTo(Ad::class, 'ad_id');
    }
}
