<?php

namespace Adfox\VehicleRentalMarketplace\Filament\Pages;

use Adfox\VehicleRentalMarketplace\Filament\Clusters\VehicleRental;
use App\Settings\VehicleRentalSettings;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Forms\Get;
use Filament\Pages\SettingsPage;

class ManageVehicleRentalSettings extends SettingsPage
{
    protected static ?string $title = 'Settings';
    protected static ?string $navigationLabel = 'Settings';
    protected static ?string $navigationIcon = 'heroicon-o-cog-6-tooth';
    protected static string $settings = VehicleRentalSettings::class;

    protected static ?string $cluster = VehicleRental::class;
    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Section::make('Booking Fees')
                    ->schema([
                        // Toggle::make('booking_fees_per_listing')
                        //     ->label('Enable Booking Fees per Listing')
                        //     ->helperText('Allow individual listing owners to enable or disable booking fees for their listings.'),

                        Toggle::make('enable_booking_fee')
                            ->live()
                            ->label('Global Booking Fee')
                            ->helperText('Globally enable or disable booking fees across the entire platform.'),

                        Select::make('booking_fee_type')
                            ->label('Booking Fee Type')
                            ->hidden(fn(Get $get) => !$get('enable_booking_fee'))
                            ->helperText('Choose the fee structure: either percentage or flat fee.')
                            ->options([
                                'percentage' => 'Percentage',
                                'flat' => 'Flat Fee',
                            ])
                            ->required(),
                        TextInput::make('booking_fee_value')
                            ->hidden(fn(Get $get) => !$get('enable_booking_fee'))
                            ->label('Booking Fee Value')
                            ->minValue(0)
                            ->helperText('Set the booking fee amount, either as a percentage (e.g., 10%) or a flat fee (e.g., $10).')
                            ->numeric()
                            ->required(),
                    ])
                    ->columns(2),

                Section::make('Down Payment Settings')
                    ->schema([
                        Toggle::make('down_payment_enabled')
                            ->label('Enable Down Payment')
                            ->helperText('Allow users to pay a portion of the booking price upfront.'),
                    ])
                    ->columns(2),

                Section::make('Whatsapp Settings')
                    ->schema([
                        Toggle::make('enable_whatsapp')
                            ->label('Enable Whatsapp')
                            ->helperText('Allow users to chat with whatsapp.'),
                    ])
                    ->columns(2),
            ]);
    }
}
