<div>
    <style>
        .time-line {
            padding-left: 20px;
            position: relative;
        }

        .time-line::before {
            content: "";
            position: absolute;
            height: 65%;
            border-left: 3px solid #FDAE4B;
            animation: grow-line 5s ease-out forwards;
        }

        /* Animation for the vertical line */
        @keyframes grow-line {
            from {
                height: 0;
            }

            to {
                height: 65%;
            }
        }

        .order-dot {
            position: relative;
        }

        .order-dot::before {
            content: "";
            display: block;
            background-color: black;
            width: 6px;
            height: 6px;
            border-radius: 100%;
            position: absolute;
            left: -21px;
        }

        .fi-section-content-ctn {
            border: none;
        }

        .fi-section-content {
            padding: 5px 24px 0px;
        }
    </style>
    {{-- header section  --}}
    <livewire:layout.header context="home" lazy />

    <div class=" container mx-auto px-4">
        <a href="/my-booking" class=" flex items-center gap-x-2 py-5 sm:pt-7 sm:pb-9 cursor-pointer w-fit">
            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                stroke="currentColor" class=" w-5 h-5">
                <path stroke-linecap="round" stroke-linejoin="round" d="M10.5 19.5 3 12m0 0 7.5-7.5M3 12h18" />
            </svg>
            <h2 class=" text-lg sm:text-xl font-semibold">{{ __('messages.t_back_to_my_order') }}</h2>
        </a>
        <div class=" flex justify-between items-center">
            <h2 class=" text-lg sm:text-xl font-semibold">{{ __('messages.t_booking_iD') }}: {{$bookingDetails->booking_id}}</h2>
        </div>

        {{-- order section  --}}
        <section
            class=" py-8 sm:py-10 grid grid-cols-1 md:grid-cols-5 gap-y-7 md:gap-x-14">
            {{-- card section  --}}
            <div
                class=" md:col-span-3 md:row-span-3 border border-gray-950/5 dark:border-white/10 classic:border-black rounded-lg bg-white dark:bg-gray-900 h-fit">
                <div class=" p-5 sm:px-6 sm:py-7">
                    <div class=" flex gap-x-4">
                        <div>
                            <img src="{{$bookingDetails->ads->primary_image}}" alt="" class=" max-w-[5rem] md:max-w-[9.375rem]">
                        </div>
                        <div class=" flex flex-col justify-between w-full">
                            <div class=" w-full">
                                <div class=" flex flex-wrap justify-between items-center w-full">
                                    <h3 class="sm:text-lg font-semibold">{{$bookingDetails->ads->title}}</h3>
                                    <span class="font-medium bg-[#F2FDF5] text-[#147638]">{{ ucfirst($bookingDetails->status) }}</span>
                                </div>
                                <div class=" text-sm sm:text-base text-[#71717A]">{{$bookingDetails->ads->user->name}} <span class=" md:block text-xs sm:text-sm text-[#71717A]">Member since
                                    {{ \Carbon\Carbon::parse($bookingDetails->ads->created_at)->format('M Y') }}</span></div>
                            </div>
                            <div class=" flex flex-wrap md:justify-between items-center gap-x-3 md:gap-x-10 w-full">
                                <span class=" text-xs sm:text-sm font-semibold">${{$bookingDetails->ads->price}}/ day</span>
                                <span
                                    class=" text-[16] sm:text-s px-2 py-1 rounded-full flex gap-2 items-center"><x-heroicon-o-map-pin class="w-5 h-5" />  {{ $bookingDetails->address->city->name }},
                                    {{ $bookingDetails->address->state->name }},
                                    {{ $bookingDetails->address->country->name }},
                                    {{ $bookingDetails->address->postal_code }}</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class=" border-t border-gray-950/5 dark:border-white/10 classic:border-black bg-white dark:bg-gray-900 p-6 rounded-es-lg rounded-ee-lg">
                    <p class="font-[700] text-[20px]">{{ __('messages.t_your_trip') }}</p>
                    <div class=" flex justify-between items-end pt-5">
                        <div>
                            <h4 class=" text-lg">{{ __('messages.t_car_date') }}</h4>
                            {{ \Carbon\Carbon::parse($bookingDetails->start_date)->format('M j') }} -
                            {{ \Carbon\Carbon::parse($bookingDetails->end_date)->format('M j') }}
                         </div>
                    </div>
                    <div class=" flex justify-between items-end pt-5">
                        <div>
                            <h4 class=" text-lg">{{ __('messages.t_time') }}</h4>
                            <span class="text-[#71717A]">
                                {{ \Carbon\Carbon::parse($bookingDetails->start_date)->format('D, g:i A') }} -
                                {{ \Carbon\Carbon::parse($bookingDetails->end_date)->format('D, g:i A') }}
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            {{-- summary section  --}}
            <div class=" md:col-span-2 md:row-span-1">
                <div
                    class=" border border-gray-950/5 dark:border-white/10 classic:border-black rounded-lg bg-white dark:bg-gray-900 p-5">
                    <h3 class=" sm:text-lg font-semibold">{{ __('messages.t_order_summary') }}</h3>
                    <div class=" text-sm sm:text-base grid grid-cols-1 gap-y-5 pt-5">
                        <div class=" flex justify-between items-center">
                            <h4>${{$bookingDetails->ads->price}} x {{$bookingDetails->days}} days</h4>
                            <h4 class=" font-medium">${{$bookingDetails->ads->price * $bookingDetails->days}}</h4>
                        </div>
                        <div class=" flex justify-between items-center">
                            <h4>{{ __('messages.t_tax') }}</h4>
                            <h4 class=" dark:text-white text-[#307A16] font-medium">${{$this->tax}}</h4>
                        </div>
                        <div class=" border-t border-gray-950/5 dark:border-white/10 classic:border-black"></div>
                        <div class=" leading-none text-base sm:text-lg font-bold flex justify-between items-center">
                            <h2>{{ __('messages.t_total_amount') }}</h2>
                            <h2>${{$bookingDetails->total}}</h2>
                        </div>
                    </div>
                </div>
            </div>
            <div
                class=" md:col-span-2 md:row-span-2 border border-gray-950/5 dark:border-white/10 classic:border-black rounded-lg bg-white dark:bg-gray-900 p-5 h-fit">
                <h3 class=" sm:text-lg font-semibold">{{ __('messages.t_payment_information') }}</h3>
                <div class=" text-sm sm:text-base grid grid-cols-1 gap-y-5 pt-5">
                    <div class=" flex justify-between items-center">
                        <h4>{{ __('messages.t_payment_method') }}</h4>
                        <h4>{{$bookingDetails->payment_type}}</h4>
                    </div>
                    <div class=" flex justify-between items-center">
                        <h4>{{ __('messages.t_date_of_processing') }}</h4>
                        <h4>{{ \Carbon\Carbon::parse($bookingDetails->created_at)->format('d M, Y \a\t h:i A') }}</h4>
                    </div>
                    {{-- <div class=" border-t border-gray-950/5 dark:border-white/10 classic:border-black"></div>
                    <div class=" flex justify-between">
                        <h4>Shipping Information</h4>
                        <h4 class=" text-end">Sridharan <span class=" block">1/103, A, Main Street,</span> <span
                                class=" block">Madurai, 625001</span></h4>
                    </div>
                    <div class=" flex justify-between items-center">
                        <h4>Phone Number</h4>
                        <h4>+91 9597308088</h4>
                    </div> --}}
                </div>
            </div>
        </section>

        {{-- cancellation section  --}}
        {{-- <section class=" pb-10">
            <h3 class=" text-lg sm:text-xl font-semibold">Cancellation & Return Policy</h3>
            <p class=" text-sm sm:text-base pt-3">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Cras non sodales nisi. Duis at nisi id magna gravida dapibus. Vivamus at eleifend mi. Nam eu libero sed augue feugiat imperdiet vel quis quam. Maecenas feugiat felis imperdiet suscipit Show More</p>
        </section> --}}
    </div>

</div>
