<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAdVehicleFeatureTable extends Migration
{
    public function up()
    {
        Schema::create('ad_vehicle_feature', function (Blueprint $table) {
            $table->id();
            $table->foreignUuid('ad_id')->constrained('ads')->cascadeOnDelete();
            $table->foreignId('vehicle_feature_id')->constrained()->onDelete('cascade');
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('ad_vehicle_feature');
    }
}
