<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddNewVehicleFieldsToAdsTable extends Migration
{
    public function up()
    {
        Schema::table('ads', function (Blueprint $table) {
            $table->foreignId('make_id')->nullable()->constrained('vehicle_makes')->nullOnDelete();
            $table->foreignId('model_id')->nullable()->constrained('vehicle_models')->nullOnDelete();
            $table->string('availability_window')->nullable();
            $table->integer('min_trip_length')->nullable();
            $table->integer('max_trip_length')->nullable();
            $table->foreignId('transmission_id')->nullable()->constrained('vehicle_transmissions')->nullOnDelete();
            $table->foreignId('fuel_type_id')->nullable()->constrained('vehicle_fuel_types')->nullOnDelete();
            $table->string('mileage')->nullable();
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
        });
    }

    public function down()
    {
        Schema::table('ads', function (Blueprint $table) {
            $table->dropForeign(['make_id']);
            $table->dropForeign(['transmission_id']);
            $table->dropForeign(['fuel_type_id']);
            $table->dropColumn([
                'make_id',
                'availability_window',
                'min_trip_length',
                'max_trip_length',
                'transmission_id',
                'fuel_type_id',
                'mileage',
                'start_date',
                'end_date'
            ]);
        });
    }
}
