<?php

namespace Adfox\Subscription\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Filament\Notifications\Notification as FilamentNotification;
use Filament\Notifications\Actions\Action;

class PaymentSucceededNotification extends Notification
{
    use Queueable;

    public $invoice;
    /**
     * Create a new notification instance.
     */
    public function __construct($invoice)
    {
        $this->invoice=$invoice;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail', 'database'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
        ->subject(trans('messages.t_et_payment_succeed_subject'))
        ->line(trans('messages.t_et_payment_succeed_body'))
        ->action(trans('messages.t_et_view_invoice'), $this->invoice->hosted_invoice_url)
        ->line(trans('messages.t_et_thank_you_message'));    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toDatabase(object $notifiable): array
    {
        $notificationTitle = trans('messages.t_et_payment_succeed_subject');
        $notificationBody = trans('messages.t_et_payment_succeed_body');

        return FilamentNotification::make()
            ->success()
            ->title($notificationTitle)
            ->body($notificationBody)
            ->actions([
                Action::make(trans('messages.t_et_view_invoice'))
                    ->button()
                    ->markAsRead()
                    ->openUrlInNewTab()
                    ->url(fn(): string => $this->invoice->hosted_invoice_url)
            ])
            ->getDatabaseMessage();
    }
}
