<?php
namespace Adfox\Subscription\Livewire\Plan;

use App\Models\Plan;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Livewire\Attributes\Url;
use Livewire\Component;

class PlanDetails extends Component implements HasForms
{
    use InteractsWithForms;

    public $plans;

    #[Url]
    public $selectedPlan;


    public function mount()
    {
        $this->getPlans();
    }


    public function getPlans()
    {
        //Fetch active plans
        $this->plans = Plan::isActive()->withCount('features')->get();
    }

    /**
     * Render the component view.
     *
     * @return \Illuminate\View\View The view to render.
     */
    public function render()
    {
        return view('subscription::plan.plan-details');
    }
}
