<div class="grid grid-cols-auto-fill-250 gap-4 ">
    @forelse ($plans as $index=>$plan)
    <article wire:key='plan-{{$plan->id}}'
        class="group flex  w-full max-w-xs flex-col overflow-hidden ring-1 ring-gray-950/5 dark:bg-gray-900 dark:ring-white/10 bg-white p-6 text-slate-700   dark:text-slate-300 flex-auto rounded-xl transition-all hover:transform hover:-translate-x-1 hover:-translate-y-1 hover:shadow-md classic:ring-black classic:hover:shadow-custom"
        x-data="truncate">
        {{-- <span
            class="ml-auto w-fit rounded-xl bg-primary-700 px-2 py-1 text-xs font-medium text-slate-100 dark:bg-primary-600 dark:text-slate-100">TOP
            CHOICE</span> --}}
        <h3 class="text-xl text-balance md:text-2xl truncate font-bold text-black dark:text-white"
            aria-describedby="planDescription-{{$index}}" title="{{$plan->name}}">{{$plan->name}}</h3>

        <p id="planDescription-{{$index}}" class="mt-2 text-pretty text-sm font-medium line-clamp-3 "
            x-init="$nextTick(() => { setTruncate({{$index}}, $el) })">{{$plan->description}}</p>
        <template x-if="truncatable[{{$index}}]">
            <div class="text-xs text-blue-600 underline">

                <button
                    @click="document.getElementById('planDescription-{{$index}}').classList.remove('line-clamp-3'); truncated[{{$index}}] = false;"
                    x-show="truncated[{{$index}}];">{{__('messages.t_view_more')}}...</button>

                <button
                    @click="document.getElementById('planDescription-{{$index}}').classList.add('line-clamp-3');truncated[{{$index}}] = true;"
                    x-show="!truncated[{{$index}}];">{{__('messages.t_view_less')}}...</button>
            </div>

        </template>

        <span
            class="mt-8 text-balance text-3xl md:text-4xl font-medium text-slate-700 dark:text-slate-300">{{config('app.currency_symbol').$plan->price}}</span>
        <span class="mt-2 text-pretty text-xs font-medium"> {{__('messages.t_per')}}
            {{__('messages.t_'.$plan->invoice_interval)}}</span>
        @if($plan->features_count)
        <h4 class="mt-12 font-medium text-black dark:text-white">{{__('messages.t_features')}}</h4>
        <ul
            class="my-4 list-inside list-disc space-y-2 text-sm font-medium marker:text-lg marker:text-primary-700 dark:marker:text-primary-600">
            @foreach ($plan?->features as $key=>$feature)
            <li wire:key='feature-{{$feature->id}}'>{{$feature->name}} - {{$feature->value}}</li>
            @endforeach
        </ul>
        @endif
        @if($plan->trial_period && $plan->trial_interval)
        <button
            class="cursor-pointer  mt-auto w-full whitespace-nowrap bg-primary-700 px-4 py-2 text-center text-sm font-medium tracking-wide text-slate-100 transition hover:opacity-75 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-primary-700 active:opacity-100 active:outline-offset-0 dark:bg-primary-600 dark:text-slate-100 dark:focus-visible:outline-primary-600 rounded-lg">Start
            your free trial</button>
        @else
        <button wire:click='$parent.selectPlan({{$plan->id}})' id="plan-button-{{$plan->id}}"
            class="cursor-pointer mt-auto w-full whitespace-nowrap bg-primary-700 px-4 py-2 text-center text-sm font-medium tracking-wide text-slate-100 transition hover:opacity-75 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-primary-700 active:opacity-100 active:outline-offset-0 dark:bg-primary-600 dark:text-slate-100 dark:focus-visible:outline-primary-600 rounded-lg">
            <span wire:loading.remove wire:target="$parent.selectPlan({{$plan->id}})">{{ __('messages.t_choose')
                }}</span>

            <x-loading-animation wire:target="$parent.selectPlan({{$plan->id}})" />

        </button>

        @endif
    </article>
    @empty
    <section class="place-self-center col-span-4">
        <img src="/images/no-plan.svg" alt="" srcset="">
        <p class="p-4">{{__('messages.t_no_plans_found')}}</p>
    </section>
    @endforelse

    <script>
        document.addEventListener('alpine:init', () => {
        Alpine.data('truncate', () => ({
            truncated: [false, false],
            truncatable: [false, false],
            setTruncate(index, element) {
          if (element.offsetHeight < element.scrollHeight ||
              element.offsetWidth < element.scrollWidth) {
              // your element has an overflow, ie. truncated
              // show read more button
              this.truncated[index] = true;
              this.truncatable[index] = true;
          } else {
              // your element doesn't have overflow
              this.truncated[index] = false;
              this.truncatable[index] = false;

          }
        } ,
        isTruncated(index) {
          return true;
        }
        }))
    })
    </script>
</div>
