<?php

namespace Adfox\Paymongo\Providers;

use Adfox\Paymongo\Livewire\PaymongoPayment;
use Filament\Panel;
use Illuminate\Support\ServiceProvider;
use Illuminate\Database\Eloquent\Relations\Relation;
use Adfox\Paymongo\PaymongoPlugin;
use Livewire\Livewire;

class PaymongoServiceProvider extends ServiceProvider
{
    public function register()
    {
        Panel::configureUsing(fn (Panel $panel) => $panel->plugin(new PaymongoPlugin()));
    }

    public function boot()
    {
        Relation::morphMap([]);
        Livewire::component('paymongo-payment', PaymongoPayment::class);


    }

}
