<?php

namespace Adfox\Paymongo\Filament\Pages;
use App\Settings\PayMongoSettings;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;
use Illuminate\Support\Facades\Config;

class ManagePaymongo extends SettingsPage
{
    protected static ?string $title = 'PayMongo Settings';

    protected static ?string $navigationGroup = 'Payment Gateways';

    protected static ?string $navigationLabel = 'PayMongo';

    protected static ?string $slug = 'manage-paymongo-settings';

    protected static string $settings = PayMongoSettings::class;

    protected static ?int $navigationSort = 20;

    protected function mutateFormDataBeforeSave(array $data): array
    {
        $previousData = app(PayMongoSettings::class);
        $filtered = [];

        foreach ($data as $key => $item) {
            // Check if the property exists in the GeneralSettings class
            if (property_exists($previousData, $key)) {
                // Get the type of the property
                $propertyType = gettype($previousData->$key);

                // If the item is null and the property type is string, set it to an empty string
                if (is_null($item) && $propertyType === 'string') {
                    $filtered[$key] = '';
                    continue;
                }
            }
            // For other cases, just copy the item as is
            $filtered[$key] = $item;
        }
        return $filtered;
    }

    public function form(Form $form): Form
    {
        $currenciesConfig = config('money.currencies');
        $currencyCodes = array_keys($currenciesConfig);
        $isDemo = Config::get('app.demo');

        return $form
            ->schema([
                TextInput::make('name')
                    ->label('PayMongo Name')
                    ->required()
                    ->helperText('Name of the PayMongo configuration.'),

                Toggle::make('status')
                    ->label('Enable PayMongo')
                    ->helperText('Toggle to enable or disable PayMongo integration.'),

                Select::make('currency')
                    ->label('Default Currency')
                    ->options(array_combine($currencyCodes, $currencyCodes))
                    ->required()
                    ->helperText('Specify the default currency for processing payments through PayMongo.'),

                $isDemo ?
                TextInput::make('public_key')
                    ->label('PayMongo Public Key')
                    ->placeholder('*****')
                    ->disabled()
                    ->helperText('Your PayMongo Public Key (hidden in demo mode).') :
                TextInput::make('public_key')
                    ->label('PayMongo Public Key')
                    ->required()
                    ->helperText('Your PayMongo Public Key.'),

                $isDemo ?
                TextInput::make('secret_key')
                    ->label('PayMongo Secret Key')
                    ->placeholder('*****')
                    ->disabled()
                    ->helperText('Your PayMongo Secret Key (hidden in demo mode).') :
                TextInput::make('secret_key')
                    ->label('PayMongo Secret Key')
                    ->required()
                    ->helperText('Your PayMongo Secret Key.'),
                    $isDemo ?
                    TextInput::make('authorization_token')
                        ->label('PayMongo Authorization token')
                        ->placeholder('*****')
                        ->disabled()
                        ->helperText('Your PayMongo Authorization token (hidden in demo mode).') :
                    TextInput::make('authorization_token')
                        ->label('PayMongo Authorization token')
                        ->required()
                        ->helperText('Your PayMongo Authorization token.'),

            ])
            ->columns(2);
    }
}
