<?php

namespace Adfox\Packages\Providers;

use Adfox\Packages\Livewire\ChoosePackage;
use Filament\Panel;
use Illuminate\Support\ServiceProvider;
use Illuminate\Database\Eloquent\Relations\Relation;
use Adfox\Packages\PackagesPlugin;
use Adfox\Packages\Livewire\Header;
use Adfox\Packages\Livewire\MyPackages;
use Adfox\Packages\Livewire\PackageDetails;
use Adfox\Packages\Livewire\PackagePayment;
use Livewire\Livewire;

class PackagesServiceProvider extends ServiceProvider
{
    public function register()
    {
        Panel::configureUsing(fn (Panel $panel) => $panel->plugin(new PackagesPlugin()));
    }

    public function boot()
    {
        Livewire::component('package-header', Header::class);
        Livewire::component('buy-package', ChoosePackage::class);
        Livewire::component('package-details', PackageDetails::class);
        Livewire::component('package-payment', PackagePayment::class);
        Livewire::component('my-packages', MyPackages::class);
    }

}
