<?php

namespace Adfox\Packages;

use Filament\Panel;
use Filament\Contracts\Plugin;

class PackagesPlugin implements Plugin
{
    public function getId(): string
    {
        return 'packages';
    }

    public function register(Panel $panel): void
    {
        if ($panel->getId() == 'admin') {
            $panel->discoverResources(
                in: __DIR__ . '/Filament/Resources',
                for: 'Adfox\\Packages\\Filament\\Resources'
            )->discoverPages(
                    in: __DIR__ . '/Filament/Pages',
                    for: 'Adfox\\Packages\\Filament\\Pages'
                );
        }
        if ($panel->getId() == 'app') {
            $panel->discoverResources(
                in: __DIR__ . '/Filament/App/Resources',
                for: 'Adfox\\Packages\\Filament\\App\\Resources'
            )->discoverPages(
                    in: __DIR__ . '/Filament/App/Pages',
                    for: 'Adfox\\Packages\\Filament\\App\\Pages'
                );
        }
    }

    public function boot(Panel $panel): void
    {
    }
}
