<div>
    @if($pkg_type == 'single' && $groupedPromotions)
       @foreach($groupedPromotions as $promotionGroup)
            <div
                wire:key="promotion-{{ $promotionGroup['promotion']->id }}"
                class="bg-white ring-1 ring-gray-950/5 dark:bg-gray-900 dark:ring-white/10 px-3 py-4 rounded-xl mb-6 cursor-pointer classic:ring-black"
            >
                    <div class="flex gap-x-2 items-center">
                        <img src="{{ asset('images/' . $promotionGroup['promotion']->image) }}" alt="{{ $promotionGroup['promotion']->name }}" class="w-10 h-10">
                        <div>
                            <p class="font-semibold">
                               {{ $promotionGroup['promotion']->name }}
                            </p>
                            <p class="text-sm ">{{  $promotionGroup['promotion']->description }}</p>
                        </div>
                    </div>
                    <div class="space-y-4 mt-4">
                        @foreach($promotionGroup['items'] as $item)
                            @php
                                $title = __('messages.t_promotion_for_duration', [
                                    'promotionName' => $promotionGroup['promotion']->name,
                                    'duration' => $item->promotion->package->duration
                                ]);
                            @endphp

                            @if($promotionGroup['promotion']->id == 4 && in_array($item->id, $selectedItems))
                                <form wire:submit>
                                    <div class="mb-5">
                                        {{ $this->form }}
                                    </div>
                                </form>
                            @endif
                            <x-packages::package-single-item
                               wire:key="single-promotion-{{ $item->id }}"
                               :item="$item"
                               :selectedItems="$selectedItems"
                               :title="$title"
                            />
                        @endforeach
                    </div>



            </div>

        @endforeach
    @elseif($pkg_type == 'apply' && $activeOrderPackageItems)
        <div>
            @foreach($activeOrderPackageItems as $orderPackageItem)
                <x-packages::package-apply-card
                    wire:key="order-package-item-{{ $orderPackageItem->id }}"
                    :item="$orderPackageItem"
                    :selectedItems="$selectedItems"
                />

                @if($orderPackageItem->promotion_id == 4 && in_array($orderPackageItem->id, $selectedItems))
                    <form wire:submit>
                        <div class="mb-5">
                            {{ $this->form }}
                        </div>
                    </form>
                @endif
            @endforeach
        </div>
    @else
        <div>
            @foreach($packages as $package)
                <div wire:key="package-{{ $package->id }}" class="rounded-xl border border-gray-200 dark:border-white/10 classic:border-black mb-6 bg-white">
                    <div class="border-b border-gray-200 dark:border-white/10 classic:border-black md:p-6 p-4">
                        <h2 class="text-lg md:text-xl font-semibold mb-1">{{ $package->name }} ({{ $package->duration }} {{ __('messages.t_days') }})</h2>
                        <p class="text-gray-600">{{ $package->features }}</p>
                    </div>
                    <div class="md:p-6 p-4">
                        <!-- Section for ad counts without promotions -->
                        <div>
                            <h3 class="md:text-lg font-semibold mb-2"> {{ __('messages.t_choose_ad_count') }}</h3>
                            <p class="text-gray-600 mb-4"> {{ __('messages.t_select_ad_option') }}</p>

                            <div class="flex space-x-4 overflow-x-auto md:py-4 ">
                                @foreach($package->packageItems->whereNull('package_promotion_id') as $item)
                                <x-packages::package-item-card wire:key="package-ad-{{ $item->id }}" :item="$item" :selectedItems="$selectedItems" />
                                @endforeach
                            </div>
                        </div>
                        @php
                            $groupedPromotions = $package->packagePromotions->groupBy('promotion.id');
                        @endphp
                        <!-- Section for ad counts with promotions -->
                        @foreach($groupedPromotions as $promotionId => $group)
                            @php
                                $promotion = $group->first()->promotion; // Assuming all items in the group have the same promotion details
                            @endphp

                            <div class="pt-6 mt-6 border-t border-gray-200 dark:border-white/10 classic:border-black">
                                <h3 class="md:text-lg font-semibold mb-2">{{ $promotion->name }}</h3>
                                <p class="text-gray-600 mb-4">{{ $promotion->description }}</p>

                                <div class="flex space-x-4 overflow-x-auto md:py-4">
                                    @foreach($group as $packagePromotion)
                                        @foreach($packagePromotion->packageItems as $item)
                                            <x-packages::package-item-card wire:key="package-promotion-{{ $item->id }}" :item="$item" :selectedItems="$selectedItems" />
                                        @endforeach
                                    @endforeach
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endforeach
        </div>
    @endif


</div>


