<header x-data="{ isSticky: false }" class=" bg-white dark:bg-gray-900 shadow-sm ring-1 ring-gray-950/5 dark:ring-white/10 classic:ring-black" :class="{ 'sticky top-0 z-10 ': isSticky }" @scroll.window="isSticky = (window.pageYOffset > 30)">
    <div class="lg:w-2/3 md:w-3/4 mx-auto px-5">
        <div class=" flex justify-between items-center py-4">
            <div class="flex items-center gap-x-2">
                <x-icon-arrow-left-1 wire:click="$parent.back()" class="w-6 h-6 cursor-pointer" />
                <h2 class="md:text-xl text-lg font-semibold">
                    {{ $pkg_type == 'multiple' ? __('messages.t_buy_packages') : __('messages.t_upgrade_ad') }}
                </h2>
            </div>
            @if (count($selectedItems) > 0 && $current == 'package-details')
                <div class="flex gap-x-2 items-center">
                    @if($pkg_type != 'apply')
                        <div class="flex font-medium gap-x-2 items-center">
                            @if($pkg_type != 'single')
                            {{ count($selectedItems) }} {{ count($selectedItems) === 1 ? __('messages.t_item') : __('messages.t_items') }}
                            <span class="h-6 block w-[0.1rem] bg-gray-600"></span>
                            @endif
                            {{ __('messages.t_total') }} {{config('app.currency_symbol')}}{{ \Number::format(floatval($totalPrice), locale: $paymentSettings->currency_locale) }}
                        </div>
                    @endif
                    <div class="fixed left-0 right-0 bottom-0  md:static bg-white md:bg-transparent px-4 py-3 md:p-0 md:border-none border-t border-gray-200 dark:border-white/10 classic:border-black">
                        @if($pkg_type == 'apply')
                           <x-button.primary class="min-w-[6rem] w-full md:w-auto  " wire:click="apply">{{ __('messages.t_apply_package') }}</x-button.secondary>
                        @else
                          <x-button.primary class="min-w-[6rem] w-full md:w-auto  " wire:click="next">{{ __('messages.t_proceed_with_payment') }}</x-button.secondary>
                        @endif
                    </div>
                </div>
            @endif
        </div>
    </div>
</header>
