@props(['item', 'selectedItems'])

@php
    use Carbon\Carbon;

    $today = Carbon::today();
    $isOfferActive = $item->offer_enabled && $item->offer_price && $item->offer_start <= $today && $item->offer_end >= $today;

    $offerPercentage = null;
    if ($isOfferActive && $item->price > $item->offer_price) {
        $discount = $item->price - $item->offer_price;
        $offerPercentage = round(($discount / $item->price) * 100);
    }
@endphp

<div wire:click="toggleSelection({{ $item->id }})"
    @class([
           'border font-medium border-gray-200 dark:border-white/10 classic:border-black bg-white rounded-md flex flex-col items-center justify-between cursor-pointer min-w-max transition-all md:hover:transform md:hover:-translate-y-1',
           'border-b-4 border-r-4' => in_array($item->id, $selectedItems),
    ])
>
    <div class="flex justify-between w-36 items-center border-b border-gray-200 dark:border-white/10 classic:border-black py-2 px-4">
        <span>{{ \Number::format(floatval($item->quantity), locale: $paymentSettings->currency_locale) }} {{ $item->quantity == 1 ? __('messages.t_ad') : __('messages.t_ads') }}</span>
        @if(in_array($item->id, $selectedItems))
            <x-heroicon-s-minus-circle class="w-8 h-8 text-danger-600" />
        @else
            <x-heroicon-s-plus-circle class="w-8 h-8 text-success-600" />
        @endif
    </div>
    <div class="p-4 text-center">
        @if($offerPercentage)
            <div>
                <span class="text-red-600">{{ config('app.currency_symbol') }}{{ \Number::format(floatval($item->offer_price), locale: $paymentSettings->currency_locale) }}</span>
                <span class="text-sm text-green-600">({{ $offerPercentage }}% {{ __('messages.t_off') }})</span>
            </div>
            <span class="line-through">{{ config('app.currency_symbol') }}{{ \Number::format(floatval($item->price), locale: $paymentSettings->currency_locale) }}</span>
        @else
            <span>{{ config('app.currency_symbol') }}{{ \Number::format(floatval($item->price), locale: $paymentSettings->currency_locale) }}</span>
        @endif
    </div>
</div>
