<?php

namespace Adfox\OfflinePayment\Livewire;


use Livewire\Component;
use App\Settings\OfflinePaymentSettings;
use App\Settings\PaymentSettings;
use Illuminate\Support\Facades\Redirect;
use App\Traits\HandlesPromotionApplication;
use App\Traits\HandlesPackageApplication;

class OfflinePayment extends Component
{

    use HandlesPackageApplication;
    use HandlesPromotionApplication;

    public $id;

    public $type;

    public $tax;

    public $data;

    public $subtotal;

    public $total;

    public $payment_gateway_params = [];

     /**
     * Mount the component and set the properties if an ad ID is provided.
     */
    public function mount($id)
    {
        $this->id = $id;
    }

    public function getPaymentSettingsProperty()
    {
        return app(PaymentSettings::class);
    }

    public function getOfflineSettingsProperty()
    {
        return app(OfflinePaymentSettings::class);
    }

    public function processPayment()
    {
        $this->data['payment_method'] = 'offline';

        if($this->type == 'PKG') {
            $routeParameters = $this->applyPackages($this->data, true);

            // Redirect to package success route
            return Redirect::route('package-success', $routeParameters);
        } else {
            $routeParameters = $this->applyPromotionsWithRedirect($this->data, true);

            // Redirect to success upgrade route
            return Redirect::route('success-upgrade', $routeParameters);
        }
    }


    /**
     * Render the component view.
     *
     * @return \Illuminate\View\View The view to render.
     */
    public function render()
    {
        return view('offline-payment::offline-payment');
    }
}
