<?php

namespace Adfox\OfflinePayment\Filament\Pages;

use App\Settings\OfflinePaymentSettings;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;

class OfflinePayment extends SettingsPage
{
    protected static ?string $title = 'Offline Payment Settings';

    protected static ?string $navigationGroup = 'Payment Gateways';

    protected static ?string $navigationLabel = 'Offline Payment';

    protected static ?string $slug = 'manage-offline-payment-settings';

    protected static string $settings = OfflinePaymentSettings::class;

    

    protected function mutateFormDataBeforeSave(array $data): array
    {
        $previousData = app(OfflinePaymentSettings::class);
        $filtered = [];

        foreach ($data as $key => $item) {
            if (property_exists($previousData, $key)) {
                $propertyType = gettype($previousData->$key);
                if (is_null($item) && $propertyType === 'string') {
                    $filtered[$key] = '';
                    continue;
                }
            }
            $filtered[$key] = $item;
        }
        return $filtered;
    }

    public function form(Form $form): Form
    {
        $currenciesConfig = config('money.currencies');
        $currencyCodes = array_keys($currenciesConfig);

        return $form
            ->schema([
                TextInput::make('name')
                    ->label('Offline Payment Name')
                    ->required()
                    ->helperText('Name of the offline payment configuration.'),

                Toggle::make('status')
                    ->label('Enable Offline Payment')
                    ->helperText('Toggle to enable or disable offline payment method.'),

                Textarea::make('instruction')
                    ->label('Payment Instructions')
                    ->required()
                    ->helperText('Instructions for making an offline payment.'),

                Select::make('currency')
                    ->label('Default Currency')
                    ->options(array_combine($currencyCodes, $currencyCodes))
                    ->required()
                    ->helperText('Default currency for offline transactions.'),

                TextInput::make('exchange_rate')
                    ->label('Exchange Rate')
                    ->numeric()
                    ->required()
                    ->helperText('Exchange rate for currency conversion.')
            ])
            ->columns(2);
    }
}
