<?php

namespace Adfox\GoogleLocationKit\Filament\Pages;


use App\Settings\GoogleLocationKitSettings;
use Filament\Forms\Components\Placeholder;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;
use Illuminate\Support\Facades\Config;

class GoogleLocation extends SettingsPage
{
    protected static ?string $title = 'Google Location Settings';

    protected static ?string $navigationGroup = 'Settings';

    protected static ?string $navigationLabel = 'Google Location';

    protected static ?string $slug = 'manage-google-location-settings';

    protected static string $settings = GoogleLocationKitSettings::class;

    protected static ?int $navigationSort = 12; // Adjust the sort order as needed

    protected function mutateFormDataBeforeSave(array $data): array
    {
        $previousData = app(GoogleLocationKitSettings::class);
        $filtered = [];

        foreach ($data as $key => $item) {
            if (property_exists($previousData, $key)) {
                $propertyType = gettype($previousData->$key);
                if (is_null($item) && $propertyType === 'string') {
                    $filtered[$key] = '';
                    continue;
                }
            }
            $filtered[$key] = $item;
        }
        return $filtered;
    }

    public function form(Form $form): Form
    {
        $isDemo = Config::get('app.demo');
        return $form
            ->schema([
                Toggle::make('status')
                    ->label('Enable Google Location')
                    ->columnSpanFull()
                    ->helperText('Toggle to enable or disable Google Location API.'),

                $isDemo ?
                Placeholder::make('api_key')
                    ->label('Google API Key')
                    ->content('*****')
                    ->hint('Hidden due to demo mode.') :
                TextInput::make('api_key')
                    ->label('Google API Key')
                    ->required()
                    ->helperText('Your Google API Key for Location Services.'),

                Toggle::make('enable_zip_code_search')
                    ->label('Enable Search by ZIP Code')
                    ->columnSpanFull()
                    ->helperText('Toggle to allow users to search for locations by ZIP code while posting ads using the Google API.'),

            ])
            ->columns(2);
    }
}
