<div>
    @if(isset($payment_gateway_params['order_id']))
      <button @click="window.makeFlutterwavePayment" type="button" id="flutterwave-payment-button" class="w-full text-[13px] font-semibold flex justify-center bg-primary-600 hover:bg-primary-700 text-white py-4 px-8 rounded tracking-wide focus:outline-none focus:shadow-outline cursor-pointer disabled:!bg-gray-200 disabled:!text-gray-600 disabled:cursor-not-allowed dark:disabled:!bg-zinc-700 dark:disabled:!text-zinc-400">
        {{ __('messages.t_pay_now') }}
      </button>
    @endif
</div>

@assets
<script src="https://checkout.flutterwave.com/v3.js"></script>
@endassets

@script
<script>
    setTimeout(function() {

                 window.makeFlutterwavePayment = function() {
                    FlutterwaveCheckout({
                        public_key     : "{{ $this->flutterwaveSettings?->public_key }}",
                        tx_ref         : "{{ $payment_gateway_params['order_id'] }}",
                        amount         : Number("{{ convertToNumber( number_format( $total * $this->flutterwaveSettings?->exchange_rate / $this->paymentSettings?->exchange_rate, 2, '.', '' ) ) }}"),
                        currency       : "{{ $this->flutterwaveSettings?->currency }}",
                        payment_options: "card, banktransfer, ussd, account, mpesa, mobilemoneyghana, mobilemoneyfranco, mobilemoneyuganda, mobilemoneyrwanda, mobilemoneyzambia, barter, nqr, credit",
                        redirect_url   : "{{ url('callback/flutterwave') }}",
                        customer       : {
                            email       : "{{ auth()->user()->email }}",
                            name        : "{{ auth()->user()->name }}",
                        },
                        customizations: {
                            title: "{{ $this->generalSettings?->site_name }}"
                        },
                    });
                }
    }, 0);
</script>
@endscript
