<?php

namespace Adfox\Feedback\Providers;

use Filament\Panel;
use Illuminate\Support\ServiceProvider;
use Illuminate\Database\Eloquent\Relations\Relation;
use Adfox\Feedback\FeedbackPlugin;
use Adfox\Feedback\Livewire\Feedback;
use Adfox\Feedback\Livewire\FeedbackList;
use Adfox\Feedback\Livewire\MyFeedback;
use Livewire\Livewire;

class FeedbackServiceProvider extends ServiceProvider
{
    public function register()
    {
        Panel::configureUsing(fn (Panel $panel) => $panel->plugin(new FeedbackPlugin()));
    }

    public function boot()
    {
        Livewire::component('feedback', Feedback::class);
        Livewire::component('feedback-list', FeedbackList::class);
        Livewire::component('my-feedback', MyFeedback::class);

    }

}
