<?php

namespace Adfox\Feedback\Livewire;

use App\Models\Feedback;
use Livewire\Component;
use App\Settings\GeneralSettings;
use App\Settings\SEOSettings;
use Artesaos\SEOTools\Traits\SEOTools as SEOToolsTrait;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Support\Facades\Auth;
use Livewire\Attributes\Reactive;
use Livewire\Attributes\Url;

class MyFeedback extends Component
{
    use SEOToolsTrait;

    public $activeTab = 'sent';

    #[Url(as: 'ref', keep: true)]
    public $referrer = '/';

    /**
     * Initializes the component.
     */
    public function mount()
    {
        $this->setSeoData();

    }


    public function setActiveTab($tabName)
    {
        $this->activeTab = $tabName;
        $this->dispatch('fetch-feedback');
    }

    /**
    * Set SEO data
    */
    protected function setSeoData()
    {
        $generalSettings = app(GeneralSettings::class);
        $seoSettings = app(SEOSettings::class);


        $separator = $generalSettings->separator ?? '-';
        $siteName = $generalSettings->site_name ?? app_name();

        $title = __('messages.t_my_feedback') . " $separator " . $siteName;
        $description = $seoSettings->meta_description;

        $this->seo()->setTitle($title);
        $this->seo()->setDescription($description);
    }

    /**
     * Renders the MyAccount view.
     */
    public function render()
    {
        return view('feedback::my-feedback');
    }
}
