<div class="space-y-4">
    @if($feedbackDetails->isEmpty())
       <x-not-found description="{{ __('messages.t_no_feedback_found_for_this_seller') }}" />
    @else
    @foreach ($feedbackDetails as $feedback)
        <div wire:key="feedback-{{$feedback->id}}" class="bg-white dark:bg-gray-900/20 p-4 rounded-lg shadow ring-1 ring-gray-950/10 dark:ring-white/10 classic:ring-black">
            <div class="flex items-center justify-between mb-2">
                <h3 class="font-semibold text-gray-800 dark:text-gray-200">{{ $feedback->buyer->name ?? 'Anonymous' }}</h3>
                <span class="text-sm text-gray-600 dark:text-gray-200">{{ $feedback->created_at->format('d/m/Y') }}</span>
            </div>
            <p class="text-gray-700 dark:text-gray-200">{{ $feedback->detail }}</p>

            <div class="flex items-center justify-between mt-2">
                <div class="flex items-center gap-x-2">
                    @if ($feedbackSettings->enable_likes)
                    <button class="flex items-center dark:text-gray-200 text-gray-700 hover:text-gray-900 " wire:click="likeFeedback({{ $feedback->id }})">
                        {{__('messages.t_like_feedback')}}
                    </button>
                    @endif
                    @if ($feedbackSettings->enable_replies)
                    {{ ($this->replyAction)(['feedbackId' => $feedback->id]) }}
                    @endif
                </div>
                @if ($feedbackSettings->enable_likes)
                <span class="text-green-500 flex items-center">
                    <x-heroicon-o-hand-thumb-up class="w-6 h-6" />
                    {{ $feedback->likes->count() }}
                </span>
                @endif
            </div>

            {{-- Replies List --}}
            <div class="mt-4 space-y-3 pl-4">
                @foreach ($feedback->replies as $reply)
                    <div wire:key="reply-{{$reply->id}}"  class="bg-gray-100 dark:bg-gray-900/40 p-3 rounded">
                        <div class="flex justify-between items-center">
                            <span class="font-medium text-gray-800 dark:text-gray-200">{{ $reply->user->name }}</span>
                            <span class="text-xs text-gray-500 dark:text-gray-200">{{ $reply->created_at->format('d/m/Y') }}</span>
                        </div>
                        <p class="text-gray-600">{{ $reply->reply }}</p>
                    </div>
                @endforeach
            </div>
        </div>
    @endforeach
    @endif
    <x-filament-actions::modals />
</div>
