<?php

namespace Adfox\Blog\Filament\Pages;

use App\Settings\BlogSettings;
use Filament\Pages\SettingsPage;
use Filament\Forms\Form;
use Filament\Forms\Components\Toggle;

class Blog extends SettingsPage
{
    protected static ?string $title = 'Blog Settings';

    protected static ?string $navigationGroup = 'Blog';

    protected static ?string $navigationLabel = 'Blog Settings';

    protected static ?string $slug = 'manage-blog-settings';

    protected static string $settings = BlogSettings::class;

    protected static ?int $navigationSort = 12; // Adjust the sort order as needed

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Toggle::make('enable_blog')
                    ->label('Enable Blog')
                    ->helperText('Toggle to activate or deactivate the blog.'),

                Toggle::make('enable_comments')
                    ->label('Enable Comments')
                    ->helperText('Toggle to enable or disable comments on the blog.'),
            ])
            ->columns(2);
    }
}
