<?php

namespace Adfox\Appearance\Filament\Resources\BannerResource\Widgets;

use App\Models\BannerAnalytics;
use Carbon\Carbon;
use Filament\Widgets\ChartWidget;
use Illuminate\Support\Facades\DB;

class YearlyBannerClicksChart extends ChartWidget
{
    protected static ?string $heading = 'Yearly Banner Clicks';

    public $bannerId;

    protected function getData(): array
    {
        $startOfDecade = Carbon::now()->startOfDecade();
        $endOfDecade = Carbon::now()->endOfDecade();

        // Get yearly view and click counts for the specified banner
        $data = BannerAnalytics::select(
                DB::raw('DATE_FORMAT(created_at, "%Y") as year'),
                DB::raw('SUM(CASE WHEN event = "view" THEN 1 ELSE 0 END) as views'),
                DB::raw('SUM(CASE WHEN event = "click" THEN 1 ELSE 0 END) as clicks')
            )
            ->where('banner_id', $this->bannerId)
            ->whereBetween('created_at', [$startOfDecade, $endOfDecade])
            ->groupBy('year')
            ->orderBy('year')
            ->get();


        // Prepare data for chart
        $years = $data->pluck('year');
        $clicks = $data->pluck('clicks');
        return [
            'datasets' => [
                [
                    'label' => 'Clicks',
                    'data' => $clicks,
                    'backgroundColor' => '#36A2EB',
                    'borderColor' => '#9BD0F5',
                ],
            ],
            'labels' => $years,
        ];
    }

    protected function getType(): string
    {
        return 'bar';
    }
}
