<?php

namespace Adfox\Appearance\Filament\Resources\BannerResource\Widgets;

use App\Models\BannerAnalytics;
use Carbon\Carbon;
use Filament\Widgets\ChartWidget;
use Illuminate\Support\Facades\DB;

class MonthlyBannerClicksChart extends ChartWidget
{
    protected static ?string $heading = 'Monthly Banner Clicks';

    public $bannerId;

    protected function getData(): array
    {
        $startOfYear = Carbon::now()->startOfYear();
        $endOfYear = Carbon::now()->endOfYear();

        // Get monthly view and click counts for the specified banner
        $data = BannerAnalytics::select(
            DB::raw('DATE_FORMAT(created_at, "%Y-%m") as month'),
            DB::raw('SUM(CASE WHEN event = "view" THEN 1 ELSE 0 END) as views'),
            DB::raw('SUM(CASE WHEN event = "click" THEN 1 ELSE 0 END) as clicks')
        )
        ->where('banner_id', $this->bannerId)
        ->whereBetween('created_at', [$startOfYear, $endOfYear])
        ->groupBy('month')
        ->orderBy('month')
        ->get();

        // Prepare data for chart
        $months = $data->pluck('month');
        $clicks = $data->pluck('clicks');
        return [
            'datasets' => [
                [
                    'label' => 'Clicks',
                    'data' => $clicks,
                    'backgroundColor' => '#36A2EB',
                    'borderColor' => '#9BD0F5',
                ],
            ],
            'labels' => $months,
        ];
    }

    protected function getType(): string
    {
        return 'bar';
    }
}
