<?php

namespace Adfox\Appearance\Filament\Resources;

use Adfox\Appearance\Filament\Resources\BannerResource\Pages;
use Adfox\Appearance\Filament\Resources\BannerResource\RelationManagers;
use App\Models\Banner;
use Filament\Forms;
use Filament\Forms\Components\SpatieMediaLibraryFileUpload;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Forms\Components\ColorPicker;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\TextInput;
use Filament\Tables\Columns\ImageColumn;
use Filament\Tables\Columns\TextColumn;

class BannerResource extends Resource
{
    protected static ?string $model = Banner::class;
    protected static ?string $navigationGroup = 'Appearance';


    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                FileUpload::make('image')
                    ->image()
                    ->imageEditor()
                    ->required()
                    ->helperText('Recommended image size: 1280x392px for best quality.'),
                TextInput::make('alternative_text'),
                TextInput::make('link')
                    ->url(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->modifyQueryUsing(fn(Builder $query) => $query->orderBy('order', 'asc'))
            ->reorderable('order')
            ->columns([
                // TextColumn::make('name'),
                ImageColumn::make('image'),
                TextColumn::make('')
                    ->label('View count')
                    ->default(function ($record) {
                        $count = Banner::whereId($record->id)->withCount([
                            'bannerAnalytics as views_count' => function (Builder $query) {
                                $query->where('event', 'view');
                            }
                        ])->first();
                        return $count->views_count ?? 0;
                    }),
                TextColumn::make('banner_analytics_count')
                    ->label('Click count')
                    ->counts([
                        'bannerAnalytics' => fn(Builder $query) => $query->where('event', 'click'),
                    ]),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\Action::make('view_report')
                    ->icon('heroicon-o-chart-bar')
                    ->url(fn($record) => route('filament.admin.resources.banners.report', ['record' => $record->id])),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListBanners::route('/'),
            'create' => Pages\CreateBanner::route('/create'),
            'edit' => Pages\EditBanner::route('/{record}/edit'),
            'report' => Pages\ReportBanner::route('/{record}/report'),
        ];
    }
}
