<?php
namespace Adfox\Appearance\Enums;


enum HomePageSectionType: string
{
    case Categories = 'categories';
    case Spotlight = 'spotlight';
    case FreshAds = 'fresh_ads';

    public static function getLabel($value): ?string
    {
        return match ($value) {
            self::Categories->value => 'Categories',
            self::Spotlight->value => 'Spotlight',
            self::FreshAds->value => 'Fresh ads',
        };
    }
}
