<div x-data="{ state: $wire.$entangle('data.theme') }" >
    <label class="text-sm font-medium leading-6 text-gray-950 dark:text-white">Theme</label>
        <div class="flex gap-2 w-full">

    <div @click="state='classic_frame'" class="w-[300px] border-black  rounded-md p-2"
       >
        <div class="mx-2" x-bind:class="state == 'classic_frame' ? 'font-bold  ' : ''">
            <div class="flex items-center mb-4">
                <input id="classic_frame" type="radio" x-model="state" value="classic_frame" name="default-radio" class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                <label for="classic_frame" class="ms-2 text-sm  text-gray-900 dark:text-gray-300">Classic Frame</label>
            </div>
        </div>
        <div
            class=" shadow-sm flex-none  bg-white rounded-xl  hover:shadow-md hover:border-black transition-all   dark:bg-gray-900 border-black border classic:hover:shadow-custom relative flex flex-col md:pb-0 pb-[2.5rem]">
            <div class="pb-0 p-2 md:p-3  md:pb-0 relative  md:w-auto md:h-auto flex-none">
                <div class="absolute top-4 right-4 z-[1]">
                    <x-heroicon-o-heart class="w-6 h-6 dark:text-gray-400 stroke-1" />
                </div>
                <div
                    class="px-2 py-1 whitespace-nowrap text-xs md:text-sm font-medium border classic:border-black border-transparent  dark:border-white/10 absolute top-2 md:rounded-none md:top-6 left-3 right-3 md:right-auto md:left-6 bg-red-600 text-black">
                    {{ __('messages.t_urgent_ad') }}
                </div>
                <img src="{{ asset('/images/placeholder.jpg') }}"
                    class="aspect-square object-cover h-32 flex w-full md:h-[12rem] rounded-xl">
            </div>

            <div class="flex-grow flex flex-col">
                <div class="flex-grow md:border-b border-gray-200  dark:border-white/10 classic:border-black mt-auto">
                    <div class="px-2 md:px-3 py-3 h-full flex flex-col ">
                        <h3 class="mb-1 text-sm md:text-base line-clamp-2 font-medium">Noise-Cancelling Earbuds</h3>
                        <div class="flex items-center mb-2 text-sm ">
                            <x-icon-pin-location class="w-5 h-5 dark:text-gray-500" />
                            <span class="font-light ml-1 line-clamp-1">{{ fake()->city }}</span>
                        </div>
                        <span
                            class=" md:block text-gray-500 dark:text-gray-400 text-sm">{{ \Carbon\Carbon::parse(now())->translatedFormat('M j') }}</span>
                    </div>
                </div>
                <div
                    class="flex justify-between items-center px-3 py-2 md:py-3 md:border-none border-t md:static absolute left-0 right-0 bottom-0 border-gray-200  dark:border-white/10 classic:border-black">
                    <div class="flex items-center gap-x-2">
                        <div class="price block p-1 pr-[calc(0.5rem+1em)] text-black relative border border-r-0 border-black  overflow-hidden whitespace-nowrap truncate leading-[1.1rem] text-sm rtl:scale-x-[-1] "
                            itemprop="price" content="1">
                            $ 100
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <div @click="state='ad_fusion'" class="w-[300px] border-black  rounded-md p-2"
        >
        <div class="mx-2" x-bind:class="state == 'ad_fusion' ? 'font-bold  ' : ''">
            <div class="flex items-center mb-4">
                <input id="ad_fusion" type="radio" value="ad_fusion" x-model="state" name="default-radio" class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600">
                <label for="ad_fusion" class="ms-2 text-sm  text-gray-900 dark:text-gray-300">Ad Fusion</label>
            </div>
        </div>
        <div
            class="w-full shadow-sm flex-none bg-white rounded-xl hover:shadow-md hover:border-black transition-all  dark:bg-gray-900 border-black border classic:hover:shadow-custom relative flex flex-col md:pb-0 pb-[2.5rem]">
            <div class="pb-0 p-2 md:p-3  md:pb-0 relative  md:w-auto md:h-auto flex-none">

                <img src="{{ asset('/images/placeholder.jpg') }}"
                    class="aspect-square object-cover h-28 flex w-full md:h-[12rem] rounded-xl">

                <div
                    class="bg-[#b0b0b085] flex gap-2 w-fit px-1 py-[0.10rem] items-center rounded-md absolute top-4 right-4 z-[1]">
                    <x-heroicon-o-camera class="h-5 w-5" />
                    <span>3</span>
                </div>
            </div>

            <div class="flex-grow flex flex-col">
                <div class="flex-grow md:border-b border-gray-200  dark:border-white/10 classic:border-black mt-auto">
                    <div class="px-2 md:px-3 py-3 h-full flex flex-col ">
                        <h3 class="mb-2 text-sm md:text-base line-clamp-2 font-medium">Noise-Cancelling Earbuds</h3>
                        <div class="mb-2 flex gap-1">
                            <div
                                class="px-1.5 py-1 whitespace-nowrap text-xs font-normal border classic:border-black border-transparent  dark:border-white/10 rounded-3xl w-fit  bg-yellow-400 text-black">
                                {{ __('messages.t_featured_ad') }}
                            </div>
                        </div>
                        <div class="mt-auto">
                            <div class="flex items-center mb-2 text-sm ">
                                <x-icon-pin-location class="w-5 h-5 dark:text-gray-500" />
                                <span class="font-light ml-1 line-clamp-1">{{ fake()->city }}</span>
                            </div>
                            <span class=" md:block text-gray-500 dark:text-gray-400 text-xs">@lang('messages.t_published_on')
                                {{ \Carbon\Carbon::parse(now())->translatedFormat('d/m/Y H:i') }}</span>
                        </div>
                    </div>
                </div>
                <div
                    class="flex justify-between items-center px-3 py-2 md:py-3 md:border-none border-t md:static absolute left-0 right-0 bottom-0 border-gray-200  dark:border-white/10 classic:border-black">
                    <div class="flex items-center gap-x-2 justify-between w-full">

            <span class="line-through font-normal text-black/50">$ 100</span>
            <span>
               $ 80
            </span>
                <span class="bg-green-100 text-green-600 px-1.5 rounded-md">20%</span>
                        <div class="ml-auto">
                            <div class="cursor-pointer ">
                                <x-heroicon-o-heart class="w-6 h-6 dark:text-gray-400 stroke-1" />
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

</div>
