<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PlanFeaturesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $plans = [
            [
                'slug' => 'free-plan',
                'name' => json_encode(['en' => 'Free Plan']),
                'description' => json_encode(['en' => 'Basic features with limited access.']),
                'is_active' => true,
                'price' => 0.00,
                'signup_fee' => 0.00,
                'currency' => 'USD',
                'images_limit' => 2,
                'video_posting' => false,
                'ads_level' => 'basic',
                'banner_count' => 0,
                'enable_user_profile_description' => true,
                'enable_social_media_links' => false,
                'enable_location' => false,
                'rating' => true,
                'filter_options_level' => 'not_available',
                'seo_tools_level' => 'not_available',
                'utm_parameters_level' => 'not_available',
                'number_of_visits' => true,
                'traffic_source' => true,
                'average_view_time' => false,
                'number_of_favorites' => true,
                'contact_conversion_rate_level' => 'not_available',
                'clicks_on_link' => false,
                'demographic_analysis_level' => 'not_available',
                'product_engagement_level' => 'not_available',
                'product_performance_analysis' => false,
                'boost_analysis' => false,
                'custom_reports_level' => 'not_available',
                'automated_alerts' => false,
                'chat_limit' => 20,
                'automated_messages' => false,
                'automated_email_marketing' => false,
                'trial_period' => null,
                'trial_interval' => null,
                'invoice_period' => 1,
                'invoice_interval' => 'month',
                'grace_period' => null,
                'grace_interval' => null,
                'prorate_day' => null,
                'prorate_period' => null,
                'prorate_extend_due' => null,
                'active_subscribers_limit' => null,
                'sort_order' => 1,
                'stripe_product_id'=>null,
                'price_id' => null,
                'is_free'=>true,
                 // Limits and counts
                'ad_count'=>2,
                'feature_ad_count'=>1,
                'urgent_ad_count'=>2,
                'spotlight_ad_count'=>0,
                'website_url_count'=>0,
            ],
            [
                'slug' => 'bronze-plan',
                'name' => json_encode(['en' => 'Bronze Plan']),
                'description' => json_encode(['en' => 'Intermediate features for casual users.']),
                'is_active' => true,
                'price' => 9.99,
                'signup_fee' => 0.00,
                'currency' => 'USD',
                'images_limit' => 6,
                'video_posting' => false,
                'ads_level' => 'basic',
                'banner_count' => 2,
                'enable_user_profile_description' => true,
                'enable_social_media_links' => true,
                'enable_location' => false,
                'rating' => true,
                'filter_options_level' => 'basic',
                'seo_tools_level' => 'not_available',
                'utm_parameters_level' => 'not_available',
                'number_of_visits' => true,
                'traffic_source' => true,
                'average_view_time' => true,
                'number_of_favorites' => true,
                'contact_conversion_rate_level' => 'basic',
                'clicks_on_link' => true,
                'demographic_analysis_level' => 'not_available',
                'product_engagement_level' => 'not_available',
                'product_performance_analysis' => false,
                'boost_analysis' => true,
                'custom_reports_level' => 'not_available',
                'automated_alerts' => false,
                'chat_limit' => 100,
                'automated_messages' => false,
                'automated_email_marketing' => false,
                'trial_period' => null,
                'trial_interval' => 'null',
                'invoice_period' => 1,
                'invoice_interval' => 'month',
                'grace_period' => null,
                'grace_interval' => null,
                'prorate_day' => null,
                'prorate_period' => null,
                'prorate_extend_due' => null,
                'active_subscribers_limit' => null,
                'sort_order' => 2,
                'stripe_product_id'=>'prod_QLBXJ2AmB2mRe3',
                'price_id' => 'price_1PUVAYGgztvb8gyCNxfNFqgS',
                'is_free'=>false,
                'ad_count'=>4,
                'feature_ad_count'=>3,
                'urgent_ad_count'=>2,
                'spotlight_ad_count'=>1,
                'website_url_count'=>1,
            ],
            [
                'slug' => 'silver-plan',
                'name' => json_encode(['en' => 'Silver Plan']),
                'description' => json_encode(['en' => 'Advanced features for serious users.']),
                'is_active' => true,
                'price' => 19.99,
                'signup_fee' => 0.00,
                'currency' => 'USD',
                'images_limit' => 12,
                'video_posting' => true,
                'ads_level' => 'basic',
                'banner_count' => 4,
                'enable_user_profile_description' => true,
                'enable_social_media_links' => true,
                'enable_location' => true,
                'rating' => true,
                'filter_options_level' => 'advanced',
                'seo_tools_level' => 'basic',
                'utm_parameters_level' => 'basic',
                'number_of_visits' => true,
                'traffic_source' => true,
                'average_view_time' => true,
                'number_of_favorites' => true,
                'contact_conversion_rate_level' => 'advanced',
                'clicks_on_link' => true,
                'demographic_analysis_level' => 'basic',
                'product_engagement_level' => 'basic',
                'product_performance_analysis' => true,
                'boost_analysis' => true,
                'custom_reports_level' => 'available',
                'automated_alerts' => false,
                'chat_limit' => 600,
                'automated_messages' => true,
                'automated_email_marketing' => false,
                'trial_period' => null,
                'trial_interval' => null,
                'invoice_period' => 1,
                'invoice_interval' => 'month',
                'grace_period' => null,
                'grace_interval' => null,
                'prorate_day' => null,
                'prorate_period' => null,
                'prorate_extend_due' => null,
                'active_subscribers_limit' => null,
                'sort_order' => 3,
                'stripe_product_id'=>'prod_QPFsl8AVd1r1o1',
                'price_id' => 'price_1PYRMuGgztvb8gyCh5cxISMy',
                'is_free'=>false,
                'ad_count'=>8,
                'feature_ad_count'=>6,
                'urgent_ad_count'=>4,
                'spotlight_ad_count'=>3,
                'website_url_count'=>3,
            ],
            [
                'slug' => 'gold-plan',
                'name' => json_encode(['en' => 'Gold Plan']),
                'description' => json_encode(['en' => 'All-inclusive features for professionals.']),
                'is_active' => true,
                'price' => 49.99,
                'signup_fee' => 0.00,
                'currency' => 'USD',
                'images_limit' => 60,
                'video_posting' => true,
                'ads_level' => 'basic',
                'banner_count' => 6,
                'enable_user_profile_description' => true,
                'enable_social_media_links' => true,
                'enable_location' => true,
                'rating' => true,
                'filter_options_level' => 'advanced',
                'seo_tools_level' => 'advanced',
                'utm_parameters_level' => 'advanced',
                'number_of_visits' => true,
                'traffic_source' => true,
                'average_view_time' => true,
                'number_of_favorites' => true,
                'contact_conversion_rate_level' => 'advanced',
                'clicks_on_link' => true,
                'demographic_analysis_level' => 'advanced',
                'product_engagement_level' => 'advanced',
                'product_performance_analysis' => true,
                'boost_analysis' => true,
                'custom_reports_level' => 'advanced',
                'automated_alerts' => true,
                'chat_limit' => PHP_INT_MAX, // Unlimited interactions
                'automated_messages' => true,
                'automated_email_marketing' => true,
                'trial_period' => null,
                'trial_interval' => null,
                'invoice_period' => 1,
                'invoice_interval' => 'month',
                'grace_period' => null,
                'grace_interval' => null,
                'prorate_day' => null,
                'prorate_period' => null,
                'prorate_extend_due' => null,
                'active_subscribers_limit' => null,
                'sort_order' => 4,
                'stripe_product_id'=>'prod_QPFuo4Pw78RL0d',
                'price_id' => 'price_1PYROcGgztvb8gyCH8vj7N3G',
                'is_free'=>false,
                'ad_count'=>12,
                'feature_ad_count'=>6,
                'urgent_ad_count'=>7,
                'spotlight_ad_count'=>10,
                'website_url_count'=>10,
            ],
        ];

        // Insert the plans into the database
        DB::table('plans')->insert($plans);
    }
}
