<?php

namespace App\Observers;

use App\Models\Invoice;
use App\Notifications\InvoiceSucceededNotification;
use Illuminate\Support\Facades\Log;

class InvoiceObserver
{
    /**
     * Handle the Invoice "created" event.
     */
    public function created(Invoice $invoice): void
    {
        // dd('Invoice Created');
        // dd($invoice);
        $invoice->subscription->subscriber->notify(new \Adfox\Subscription\Notifications\InvoiceSucceededNotification($invoice));
        // Log::info('Observed');
    }

    /**
     * Handle the Invoice "updated" event.
     */
    public function updated(Invoice $invoice): void
    {
        //
    }

    /**
     * Handle the Invoice "deleted" event.
     */
    public function deleted(Invoice $invoice): void
    {
        //
    }

    /**
     * Handle the Invoice "restored" event.
     */
    public function restored(Invoice $invoice): void
    {
        //
    }

    /**
     * Handle the Invoice "force deleted" event.
     */
    public function forceDeleted(Invoice $invoice): void
    {
        //
    }
}
