<?php

namespace App\Foundation\AdBase\Traits;

use App\Models\Category;
use App\Models\City;

trait LocationFunctions
{
    public function updateLocation($ad, $value)
    {
        $category = Category::find($value);
        if ($category) {
            if (!$category->default_location && !$category->disable_location) {
                $this->dispatch('enable-location');
            } else {
                $this->handleLocationBasedOnCategory($ad, $category);
            }
        }
    }

    protected function handleLocationBasedOnCategory($ad, $category)
    {
        if ($category->default_location && $category->location_details) {
            $this->updateLocationFromCityId($ad, $category->location_details);
        }
        if ($category->disable_location) {
            $this->dispatch('hide-location');
        }
    }

    protected function updateLocationFromCityId($ad, $locationDetails)
    {
        if (isset($locationDetails['city_id'])) {
            $cityDetail = City::with('state', 'country')->find($locationDetails['city_id']);
            if (!$cityDetail) {
                return;
            }
            $ad->update([
                'latitude' => $cityDetail->latitude,
                'longitude' => $cityDetail->longitude,
                'location_name' => $cityDetail->name . ' - ' . $cityDetail->state?->name,
                'location_display_name' => "{$cityDetail->name}, {$cityDetail->state?->name}, {$cityDetail->country->name}",
                'city' => $cityDetail->name,
                'state' => $cityDetail->state->name,
                'country' => $cityDetail->country->name,
            ]);
            $this->dispatch('hide-location');
        }
    }
}
