<?php

namespace Adfox\VehicleRentalMarketplace\Providers;

use Adfox\VehicleRentalMarketplace\Console\Commands\SyncVehicleMakes;
use Adfox\VehicleRentalMarketplace\Livewire\MyBooking;
use Adfox\VehicleRentalMarketplace\Livewire\VehicleAdDetail;
use Adfox\VehicleRentalMarketplace\Livewire\VehicleBookingHistory;
use Adfox\VehicleRentalMarketplace\Livewire\VehicleBookingSucess;
use Adfox\VehicleRentalMarketplace\Livewire\VehicleSummary;
use Adfox\VehicleRentalMarketplace\VehicleRentalMarketPlacePlugin;
use Filament\Panel;
use Illuminate\Support\ServiceProvider;
use Illuminate\Database\Eloquent\Relations\Relation;
use Livewire\Livewire;

class VehicleRentalMarketplaceServiceProvider extends ServiceProvider
{
    public function register()
    {
        Panel::configureUsing(fn (Panel $panel) => $panel->plugin(new VehicleRentalMarketPlacePlugin()));

    }

    public function boot()
    {
        Livewire::component('livewire.vehicle-ad-detail', VehicleAdDetail::class);
        Livewire::component('livewire.vehicle-summary', VehicleSummary::class);
        Livewire::component('livewire.my-booking', MyBooking::class);
        Livewire::component('livewire.vehicle-booking-history', VehicleBookingHistory::class);
        Livewire::component('livewire.vehicle-booking-sucess', VehicleBookingSucess::class);

        $this->commands([
            SyncVehicleMakes::class,
        ]);
    }

}
