<?php

namespace Adfox\VehicleRentalMarketplace\Models;

use App\Models\City;
use App\Models\Country;
use App\Models\State;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Concerns\HasUuids;

class BookingAddress extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'type',
        'address',
        'city_id',
        'state_id',
        'country_id',
        'postal_code',
        'latitude',
        'longitude',
        'user_id',
        'house_number',
        'phone_number',
    ];

    public function city()
    {
        return $this->belongsTo(City::class);
    }

    public function state()
    {
        return $this->belongsTo(State::class);
    }

    public function country()
    {
        return $this->belongsTo(Country::class);
    }

    public function booking()
    {
        return $this->hasOne(VehicleCarBooking::class);
    }
}
