<?php

namespace Adfox\VehicleRentalMarketplace\Livewire;

use Adfox\VehicleRentalMarketplace\Models\VehicleCarBooking;
use Livewire\Component;
use Livewire\Attributes\Url;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Tables\Actions\Action;
use Filament\Tables\Columns\SpatieMediaLibraryImageColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Concerns\InteractsWithTable;
use Filament\Tables\Contracts\HasTable;
use Filament\Tables\Table;
use Filament\Resources\Components\Tab;
use Illuminate\Database\Eloquent\Builder;
class MyBooking extends Component implements HasForms, HasTable
{
    use InteractsWithTable;
    use InteractsWithForms;

    #[Url(as: 'ref', keep: true)]
    public $referrer = '/';
    #[Url(as: 'activeTable', keep: true)]
    public $activeTable='upgrade';

    public function table(Table $table): Table
    {
        return $table
            ->query(function(){
                if($this->activeTable=='upgrade'){
                    return VehicleCarBooking::query()->where('status','booked');
                }else{
                    return VehicleCarBooking::query()->where('status','closed');
                }
               })
            ->columns([
                SpatieMediaLibraryImageColumn::make('ads.ads')
                    ->collection('ads')
                    ->conversion('thumb')
                    ->defaultImageUrl(asset('images/placeholder.jpg'))
                    ->label('Ad Images')
                    ->size(40)
                    ->circular()
                    ->overlap(2)
                    ->stacked()
                    ->limit(3),
                TextColumn::make('ads.title'),
                TextColumn::make('booking_id'),
                TextColumn::make('start_date')->label('Pickup date & Time'),
                TextColumn::make('end_date')->label('Return date & Time'),
                TextColumn::make('days')->label('Total Days'),
                TextColumn::make('total')->label('Price'),
                TextColumn::make('status')->label('Status')->color(fn (string $state): string => match ($state) {
                    'booked' => 'success',
                }),
            ])
            ->filters([
                // ...
            ])
            ->actions([
                Action::make('View')
                ->url(function ($record) {
                    return route('history', $record->id); // Generates the correct route
                })
                ->label('View')
            ])
            ->bulkActions([
                // ...
            ]);
    }

    public function updated(){
        $this->resetTable();
    }
    /**
     * Renders the MyAccount view.
     */
    public function render()
    {
        return view('vehicle-rental-marketplace::livewire.my-booking');
    }
}
