<?php

namespace Adfox\VehicleRentalMarketplace\Console\Commands;

use Adfox\VehicleRentalMarketplace\Models\VehicleMake;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Http;

class SyncVehicleMakes extends Command
{
    protected $signature = 'fetch:makes';
    protected $description = 'Fetch makes data from API and store in the Make model';

    public function handle()
    {
        $locale = config('app.locale');
        $response = Http::get('https://listing-creation.api.autoscout24.com/makes');

        if ($response->successful()) {
            $makes = $response->json();

            $makesData = [];
            foreach ($makes as $make) {
                foreach ($make as $makedata) {
                    VehicleMake::updateOrCreate([
                        'name' => [$locale => $makedata['name']]
                    ]);
                }
            }

            // Use batch insert to optimize database writes
            VehicleMake::upsert($makesData, ['name->' . $locale], ['updated_at']);

            $this->info('Makes data stored successfully.');
        } else {
            $this->error('Failed to fetch makes data: ' . $response->status());
        }

        return Command::SUCCESS;
    }
}
