<?php


namespace Adfox\VehicleRentalMarketplace\Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Category;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;

class CategoriesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $categories = [
            'Sedans' => ['Compact Sedans', 'Midsize Sedans', 'Full-size Sedans', 'Luxury Sedans'],
            'SUVs' => ['Compact SUVs', 'Midsize SUVs', 'Full-size SUVs', 'Luxury SUVs'],
            'Vans' => ['Minivans', 'Passenger Vans', 'Cargo Vans'],
            'Trucks' => ['Light Duty Trucks', 'Heavy Duty Trucks', 'Pickup Trucks'],
            'Luxury Cars' => ['Sports Cars', 'Exotic Cars'],
            'Economy Cars' => ['Subcompact Cars', 'Compact Cars', 'Hybrid Cars', 'Electric Cars'],
            'Specialty Vehicles' => ['Off-road Vehicles', 'Convertibles', 'Classic Cars', 'Wheelchair Accessible Vehicles'],
            'Commercial Vehicles' => ['Box Trucks', 'Flatbed Trucks', 'Refrigerated Trucks', 'Moving Trucks'],
            'Recreational Vehicles' => ['Motorhomes', 'Campervans', 'Travel Trailers', 'Fifth Wheels'],
            'Motorcycles' => ['Sport Bikes', 'Cruisers', 'Touring Bikes', 'Scooters']
        ];

        $descriptions = [
            'Sedans' => 'Comfortable and efficient cars suitable for various needs',
            'SUVs' => 'Spacious vehicles ideal for families and outdoor enthusiasts',
            'Vans' => 'Perfect for group travel or cargo transportation',
            'Trucks' => 'Powerful vehicles for hauling and towing',
            'Luxury Cars' => 'High-end vehicles offering premium features and performance',
            'Economy Cars' => 'Fuel-efficient and budget-friendly options',
            'Specialty Vehicles' => 'Unique vehicles for specific needs or preferences',
            'Commercial Vehicles' => 'Vehicles designed for business and commercial use',
            'Recreational Vehicles' => 'Mobile living spaces for extended trips and camping',
            'Motorcycles' => 'Two-wheeled vehicles for efficient and exciting transportation'
        ];

        $mainCategoryOrder = 1;
        $baseDirectory = 'cardeer-categories';

        foreach ($categories as $mainCategory => $subCategories) {
            $directory = "{$baseDirectory}/{$mainCategory}.svg";

            $parent = Category::create([
                'name' => $mainCategory,
                'slug' => Str::slug(Str::limit($mainCategory, 50)),
                'icon' => $directory,
                'description' => $descriptions[$mainCategory],
                'is_visible' => true,
                'order' => $mainCategoryOrder
            ]);

            $sourceFilePath = public_path("demo/{$baseDirectory}/{$mainCategory}.svg");
            $destinationFilePath = public_path("demo/images/{$baseDirectory}/{$mainCategory}.svg");

            // Check if the SVG file exists, then associate it with the category using Spatie Media Library
            if (File::exists($sourceFilePath)) {
                File::copy($sourceFilePath, $destinationFilePath);
                $parent->addMedia($destinationFilePath)->toMediaCollection('category_icons');
            }

            $mainCategoryOrder++;

            $subCategoryOrder = 1;

            foreach ($subCategories as $subCategory) {
                Category::create([
                    'name' => $subCategory,
                    'slug' => Str::slug(Str::limit($subCategory, 50)),
                    'parent_id' => $parent->id,
                    'is_visible' => true,
                    'order' => $subCategoryOrder
                ]);

                $subCategoryOrder++;
            }
        }
    }
}
