<?php

namespace Adfox\VehicleRentalMarketplace\Database\Seeders;

use Adfox\VehicleRentalMarketplace\Models\VehicleFeature;
use Adfox\VehicleRentalMarketplace\Models\VehicleFuelType;
use Adfox\VehicleRentalMarketplace\Models\VehicleMake;
use Adfox\VehicleRentalMarketplace\Models\VehicleTransmission;
use App\Models\Ad;
use App\Models\Category;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Faker\Factory as Faker;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class AdsSeeder extends Seeder
{
    use WithoutModelEvents;

    public function run(): void
    {
        $faker = Faker::create('en_US');
        $userIds = User::pluck('id')->toArray();
        $priceTypeIds = DB::table('price_types')->pluck('id')->toArray();

        $vehicleMakes = VehicleMake::with('models')->get();
        $vehicleTransmissions = VehicleTransmission::pluck('id')->toArray();
        $vehicleFuelTypes = VehicleFuelType::pluck('id')->toArray();
        $vehicleFeatures = VehicleFeature::pluck('id')->toArray();

        $adsTemplates = [
            'Sedans' => [
                'Compact Sedans' => [
                    ['title' => 'Efficient Compact Sedan for City Driving', 'description' => "Perfect for urban commutes\n- Excellent fuel economy\n- Easy to park in tight spaces\n- Comfortable seating for 4\n- Ideal for short trips and daily use"],
                    ['title' => 'Budget-Friendly Compact Sedan Rental', 'description' => "Affordable daily rates\n- Well-maintained and clean\n- Bluetooth connectivity\n- Great for solo travelers or couples\n- Smooth ride for city exploration"],
                    ['title' => 'Compact Sedan with Advanced Safety Features', 'description' => "Latest safety technologies\n- Rearview camera and parking sensors\n- Fuel-efficient engine\n- Spacious trunk for its size\n- Perfect for business travelers"],
                    ['title' => 'Stylish Compact Sedan for Weekend Getaways', 'description' => "Modern design and comfort\n- Premium audio system\n- Panoramic sunroof\n- Sporty handling\n- Ideal for short road trips"]
                ],
                'Midsize Sedans' => [
                    ['title' => 'Comfortable Midsize Sedan for Family Trips', 'description' => "Spacious interior with ample legroom\n- Large trunk for luggage\n- Smooth ride for long journeys\n- Advanced safety features\n- Perfect for family vacations"],
                    ['title' => 'Executive Midsize Sedan for Business Travel', 'description' => "Professional appearance\n- Leather interior\n- Built-in GPS navigation\n- Quiet cabin for important calls\n- Ideal for client meetings and airport transfers"],
                    ['title' => 'Fuel-Efficient Midsize Sedan for Long Drives', 'description' => "Excellent gas mileage\n- Hybrid powertrain option\n- Comfortable seating for 5\n- Large fuel tank for fewer stops\n- Great for cross-country road trips"],
                    ['title' => 'Tech-Savvy Midsize Sedan with Modern Features', 'description' => "Advanced infotainment system\n- Apple CarPlay and Android Auto\n- 360-degree camera system\n- Adaptive cruise control\n- Perfect for tech enthusiasts"]
                ],
                'Full-size Sedans' => [
                    ['title' => 'Luxurious Full-Size Sedan for VIP Transport', 'description' => "Premium leather seating\n- Spacious rear legroom\n- Advanced climate control\n- Smooth and quiet ride\n- Ideal for executive transportation"],
                    ['title' => 'Family-Friendly Full-Size Sedan Rental', 'description' => "Generous interior space\n- Large trunk for family luggage\n- Rear-seat entertainment system\n- Multiple USB charging ports\n- Perfect for family road trips"],
                    ['title' => 'High-Performance Full-Size Sedan', 'description' => "Powerful V6 or V8 engine\n- Sport-tuned suspension\n- Premium sound system\n- Heated and ventilated seats\n- Great for enthusiasts and long drives"],
                    ['title' => 'Eco-Friendly Full-Size Hybrid Sedan', 'description' => "Fuel-efficient hybrid powertrain\n- Spacious and comfortable interior\n- Advanced driver-assist features\n- Low emissions for eco-conscious renters\n- Ideal for green-minded travelers"]
                ],
                'Luxury Sedans' => [
                    ['title' => 'Ultra-Luxury Sedan for Special Occasions', 'description' => "Top-tier luxury brand\n- Handcrafted interior details\n- Massaging seats\n- Champagne cooler\n- Perfect for weddings and VIP events"],
                    ['title' => 'High-Tech Luxury Sedan with Self-Driving Features', 'description' => "Advanced autonomous driving capabilities\n- All-digital dashboard\n- Premium surround sound system\n- Executive rear seating package\n- Ideal for tech-savvy executives"],
                    ['title' => 'Sports Luxury Sedan for Performance Enthusiasts', 'description' => "High-performance engine\n- Advanced all-wheel drive system\n- Carbon fiber interior trim\n- Race-inspired seats\n- Great for luxury car enthusiasts"],
                    ['title' => 'Classic Luxury Sedan with Timeless Elegance', 'description' => "Iconic luxury brand\n- Wood and leather interior\n- Smooth and silent ride\n- Rear privacy curtains\n- Perfect for classic car lovers"]
                ]
            ],
            'SUVs' => [
                'Compact SUVs' => [
                    ['title' => 'Versatile Compact SUV for Urban Adventures', 'description' => "Easy maneuverability in city traffic\n- Elevated seating position\n- Spacious cargo area\n- Fuel-efficient engine\n- Ideal for urban exploration"],
                    ['title' => 'Family-Friendly Compact SUV Rental', 'description' => "Safe and reliable for family use\n- Easy-to-clean interior\n- Multiple airbags and child seat anchors\n- Rearview camera for safe parking\n- Perfect for small families"],
                    ['title' => 'Sporty Compact SUV with Off-Road Capabilities', 'description' => "All-wheel drive system\n- Higher ground clearance\n- Roof rails for extra cargo\n- Sporty handling\n- Great for weekend outdoor activities"],
                    ['title' => 'Eco-Conscious Compact Hybrid SUV', 'description' => "Efficient hybrid powertrain\n- Low emissions\n- Regenerative braking system\n- Spacious interior despite compact size\n- Ideal for environmentally aware renters"]
                ],
                'Midsize SUVs' => [
                    ['title' => 'Comfortable Midsize SUV for Road Trips', 'description' => "Smooth ride on highways\n- Ample space for passengers and luggage\n- Advanced entertainment system\n- Fuel-efficient for long drives\n- Perfect for family vacations"],
                    ['title' => 'Luxurious Midsize SUV for Upscale Travel', 'description' => "Premium leather interior\n- Panoramic sunroof\n- Advanced climate control\n- High-end sound system\n- Ideal for luxury seekers"],
                    ['title' => 'Adventure-Ready Midsize SUV', 'description' => "Robust 4x4 system\n- Terrain management settings\n- Roof rack for outdoor gear\n- Towing capability\n- Great for outdoor enthusiasts"],
                    ['title' => 'Tech-Loaded Midsize SUV', 'description' => "Large touchscreen infotainment\n- 360-degree camera system\n- Wireless charging\n- Semi-autonomous driving features\n- Perfect for tech-savvy renters"]
                ],
                'Full-size SUVs' => [
                    ['title' => 'Spacious Full-Size SUV for Large Groups', 'description' => "Seating for up to 8 passengers\n- Enormous cargo space\n- Comfortable third-row seating\n- Multiple zone climate control\n- Ideal for big families or group trips"],
                    ['title' => 'Luxury Full-Size SUV with Premium Features', 'description' => "High-end leather upholstery\n- Adaptive air suspension\n- Premium audio system\n- Rear-seat entertainment\n- Perfect for VIP transportation"],
                    ['title' => 'Powerful Full-Size SUV for Towing', 'description' => "Strong V8 engine\n- High towing capacity\n- Trailer sway control\n- Integrated brake controller\n- Great for hauling boats or trailers"],
                    ['title' => 'Off-Road Capable Full-Size SUV', 'description' => "Rugged 4x4 system\n- Skid plates and off-road tires\n- Adjustable ride height\n- Hill descent control\n- Ideal for adventure seekers"]
                ],
                'Luxury SUVs' => [
                    ['title' => 'Ultra-Luxury SUV for Exclusive Travel', 'description' => "Top-tier luxury brand\n- Handcrafted interior\n- Executive rear seating\n- Advanced noise cancellation\n- Perfect for high-end clientele"],
                    ['title' => 'High-Performance Luxury SUV', 'description' => "Powerful turbocharged engine\n- Sport-tuned suspension\n- Performance brakes\n- Aerodynamic body kit\n- Ideal for luxury and speed enthusiasts"],
                    ['title' => 'Eco-Friendly Luxury Electric SUV', 'description' => "All-electric powertrain\n- Long driving range\n- Cutting-edge infotainment\n- Sustainable interior materials\n- Great for environmentally conscious luxury travelers"],
                    ['title' => 'Opulent Off-Road Luxury SUV', 'description' => "Combines luxury with off-road prowess\n- Advanced terrain response system\n- Premium leather and wood interior\n- Adjustable air suspension\n- Perfect for luxurious adventure trips"]
                ]
            ],
           'Vans' => [
                'Minivans' => [
                    ['title' => 'Family-Friendly Minivan for Comfortable Travel', 'description' => "Spacious interior for 7 passengers\n- Easy-access sliding doors\n- Ample cargo space\n- Built-in entertainment system\n- Perfect for family road trips"],
                    ['title' => 'Fuel-Efficient Minivan for Long Distance Journeys', 'description' => "Excellent fuel economy\n- Comfortable captain's chairs\n- Advanced safety features\n- Quiet cabin for peaceful rides\n- Ideal for extended family vacations"],
                    ['title' => 'Luxurious Minivan with Premium Features', 'description' => "Leather seating throughout\n- Panoramic sunroof\n- Advanced climate control\n- Premium sound system\n- Great for upscale family travel"],
                    ['title' => 'Versatile Minivan for Multi-Purpose Use', 'description' => "Easily removable seats\n- Flat load floor for cargo\n- Roof rack for extra storage\n- Towing capability\n- Suitable for both passenger and cargo needs"]
                ],
                'Passenger Vans' => [
                    ['title' => 'Spacious 12-Seater Passenger Van', 'description' => "Comfortable seating for large groups\n- High roof for easy movement\n- Powerful engine for highway driving\n- Multiple USB charging ports\n- Ideal for team or church group transport"],
                    ['title' => 'Executive Passenger Van for Corporate Travel', 'description' => "Luxurious captain's chairs\n- Conference-style seating arrangement\n- Built-in Wi-Fi hotspot\n- Smooth and quiet ride\n- Perfect for business group transportation"],
                    ['title' => 'Accessible Passenger Van with Wheelchair Ramp', 'description' => "Easy-to-use wheelchair ramp\n- Flexible seating configurations\n- Extra headroom and wide doors\n- Secure wheelchair locking system\n- Suitable for passengers with mobility needs"],
                    ['title' => 'Airport Shuttle Passenger Van', 'description' => "Ample luggage space\n- Easy entry and exit\n- GPS navigation system\n- Comfortable seating for 10\n- Great for airport transfers and hotel shuttles"]
                ],
                'Cargo Vans' => [
                    ['title' => 'High-Roof Cargo Van for Maximum Storage', 'description' => "Tall interior for standing up\n- Reinforced floor with tie-downs\n- Wide opening rear doors\n- Fuel-efficient diesel engine\n- Ideal for moving or delivery businesses"],
                    ['title' => 'Compact Cargo Van for Urban Deliveries', 'description' => "Easy to maneuver in city traffic\n- Sliding side door for quick access\n- Impressive fuel economy\n- Backup camera for safe parking\n- Perfect for small business owners"],
                    ['title' => 'Refrigerated Cargo Van for Food Transport', 'description' => "Temperature-controlled cargo area\n- Insulated walls and doors\n- Digital temperature display\n- Easy-to-clean interior\n- Suitable for catering and food delivery services"],
                    ['title' => 'Long Wheelbase Cargo Van for Extra Capacity', 'description' => "Extended length for maximum cargo space\n- High payload capacity\n- Low loading floor\n- Bluetooth connectivity\n- Great for long-distance hauling and moving"]
                ]
            ],
            'Trucks' => [
                'Light Duty Trucks' => [
                    ['title' => 'Versatile Light Duty Pickup Truck', 'description' => "Comfortable crew cab\n- Decent towing capacity\n- Good fuel efficiency\n- Easy-to-use infotainment system\n- Ideal for both work and personal use"],
                    ['title' => 'Compact Light Duty Truck for Urban Use', 'description' => "Maneuverable in tight spaces\n- Fuel-efficient four-cylinder engine\n- Comfortable interior for daily driving\n- Smart storage solutions\n- Perfect for city-based small businesses"],
                    ['title' => 'Off-Road Capable Light Duty Truck', 'description' => "4x4 capability\n- Higher ground clearance\n- Skid plates for undercarriage protection\n- All-terrain tires\n- Great for outdoor adventures and work sites"],
                    ['title' => 'Eco-Friendly Hybrid Light Duty Truck', 'description' => "Hybrid powertrain for better fuel economy\n- Reduced emissions\n- Advanced driver-assist features\n- Spacious crew cab\n- Suitable for environmentally conscious renters"]
                ],
                'Heavy Duty Trucks' => [
                    ['title' => 'Powerful Heavy Duty Truck for Serious Towing', 'description' => "High-output diesel engine\n- Maximum towing capacity\n- Trailer brake controller\n- Durable construction\n- Ideal for heavy equipment transport"],
                    ['title' => 'Luxurious Heavy Duty Truck with Premium Features', 'description' => "Premium leather interior\n- Advanced towing assistance technology\n- 360-degree camera system\n- Quiet and comfortable cabin\n- Perfect for luxury truck enthusiasts"],
                    ['title' => 'Versatile Heavy Duty Flatbed Truck', 'description' => "Durable flatbed with tie-downs\n- Powerful diesel engine\n- Extended cab for extra storage\n- Heavy-duty suspension\n- Suitable for construction and landscaping businesses"],
                    ['title' => 'Commercial-Grade Heavy Duty Box Truck', 'description' => "Large box with roll-up door\n- Liftgate for easy loading\n- Powerful yet efficient engine\n- Comfortable cab with modern amenities\n- Great for moving companies and large deliveries"]
                ],
                'Pickup Trucks' => [
                    ['title' => 'Full-Size Pickup Truck for All-Round Use', 'description' => "Spacious crew cab\n- Versatile bed with multiple tie-downs\n- Powerful V8 engine option\n- Advanced trailering features\n- Ideal for both work and family use"],
                    ['title' => 'Midsize Pickup Truck for Everyday Convenience', 'description' => "Easy to drive and park\n- Good fuel efficiency\n- Comfortable interior\n- Decent towing capacity\n- Perfect for personal use and light duty tasks"],
                    ['title' => 'Heavy-Duty Pickup Truck for Maximum Capability', 'description' => "Class-leading towing capacity\n- Durable construction\n- Advanced trailering technology\n- Comfortable interior for long hauls\n- Suitable for serious towing and hauling needs"],
                    ['title' => 'Off-Road Performance Pickup Truck', 'description' => "Enhanced 4x4 system\n- Specialized off-road suspension\n- Protective skid plates\n- All-terrain tires\n- Great for off-road enthusiasts and tough job sites"]
                ]
            ],

            'Luxury Cars' => [
                'Sports Cars' => [
                    ['title' => 'High-Performance Sports Car for Thrilling Drives', 'description' => "Powerful V8 engine\n- 0-60 mph in under 4 seconds\n- Aerodynamic design\n- Advanced suspension system\n- Perfect for sports car enthusiasts"],
                    ['title' => 'Elegant Convertible Sports Car', 'description' => "Retractable hardtop roof\n- Luxurious leather interior\n- Smooth and responsive handling\n- Premium sound system\n- Ideal for scenic drives and special occasions"],
                    ['title' => 'Track-Ready Sports Car Rental', 'description' => "Race-tuned engine\n- Carbon fiber components\n- High-performance brakes\n- Driver-focused cockpit\n- Great for track days or experiencing maximum performance"],
                    ['title' => 'All-Wheel Drive Sports Car for All-Weather Fun', 'description' => "Advanced AWD system\n- Turbocharged engine\n- All-season performance\n- Comfortable daily driver\n- Suitable for year-round sports car enjoyment"]
                ],
                'Exotic Cars' => [
                    ['title' => 'Breathtaking Italian Supercar Rental', 'description' => "Iconic Italian design\n- V12 engine with incredible sound\n- Cutting-edge aerodynamics\n- Handcrafted interior\n- Ultimate exotic car experience"],
                    ['title' => 'Futuristic Hybrid Hypercar', 'description' => "Advanced hybrid powertrain\n- Otherworldly acceleration\n- Active aerodynamics\n- Spaceship-like interior\n- For those seeking the pinnacle of automotive technology"],
                    ['title' => 'Limited Edition Exotic Sports Car', 'description' => "Rare, numbered edition\n- Bespoke craftsmanship\n- Extraordinary performance\n- Exclusive badge and features\n- A true collector's dream for special events"],
                    ['title' => 'Luxury Grand Tourer Exotic Car', 'description' => "Powerful yet comfortable for long drives\n- Exquisite interior materials\n- State-of-the-art infotainment\n- Impressive luggage space for an exotic\n- Perfect for luxurious road trips"]
                ]
            ],
            'Economy Cars' => [
                'Subcompact Cars' => [
                    ['title' => 'Fuel-Efficient Subcompact for City Driving', 'description' => "Excellent fuel economy\n- Easy to park in tight spaces\n- Nimble handling\n- Low rental rates\n- Ideal for urban commuters and budget-conscious renters"],
                    ['title' => 'Stylish Subcompact with Modern Features', 'description' => "Contemporary design\n- Touchscreen infotainment system\n- Rearview camera\n- Bluetooth connectivity\n- Great for young renters and city exploration"],
                    ['title' => 'Practical Subcompact Hatchback', 'description' => "Versatile cargo space\n- Fold-down rear seats\n- Efficient engine\n- Low running costs\n- Perfect for small shopping trips and urban adventures"],
                    ['title' => 'Eco-Friendly Subcompact with Low Emissions', 'description' => "Low CO2 emissions\n- Start-stop technology\n- Regenerative braking\n- Lightweight construction\n- Suitable for environmentally conscious city drivers"]
                ],
                'Compact Cars' => [
                    ['title' => 'Reliable Compact Sedan for Everyday Use', 'description' => "Balanced performance and efficiency\n- Comfortable seating for five\n- Good trunk space\n- User-friendly controls\n- Ideal for both city and highway driving"],
                    ['title' => 'Sporty Compact Hatchback Rental', 'description' => "Responsive handling\n- Peppy turbocharged engine\n- Sport-tuned suspension\n- Stylish exterior design\n- Fun-to-drive option for enthusiasts on a budget"],
                    ['title' => 'Well-Equipped Compact Car with Premium Features', 'description' => "Leather seating surfaces\n- Advanced safety aids\n- Premium audio system\n- Sunroof\n- Upscale feel without the luxury price tag"],
                    ['title' => 'Efficient Compact Car for Long Trips', 'description' => "Excellent highway fuel economy\n- Cruise control\n- Comfortable seats for long drives\n- Large fuel tank\n- Perfect for road trips and extended rentals"]
                ],
                'Hybrid Cars' => [
                    ['title' => 'Popular Hybrid Sedan for Eco-Conscious Renters', 'description' => "Exceptional fuel efficiency\n- Seamless hybrid powertrain\n- Regenerative braking\n- Low emissions\n- Ideal for green-minded renters and long-distance drives"],
                    ['title' => 'Spacious Hybrid SUV Rental', 'description' => "Roomy interior with hybrid efficiency\n- EV mode for short trips\n- Ample cargo space\n- Advanced hybrid display\n- Great for families wanting to reduce their carbon footprint"],
                    ['title' => 'Plug-In Hybrid for Maximum Efficiency', 'description' => "Extended electric-only range\n- Easy home and public charging\n- Flexible fuel and electric power\n- Low running costs\n- Perfect for renters curious about EVs but wanting gas backup"],
                    ['title' => 'Luxury Hybrid Sedan Rental', 'description' => "Premium features with hybrid efficiency\n- Powerful yet economical\n- Whisper-quiet operation\n- High-tech driver assists\n- Suitable for eco-friendly business or luxury travel"]
                ],
                'Electric Cars' => [
                    ['title' => 'Long-Range Electric Car for Worry-Free Trips', 'description' => "300+ mile driving range\n- Fast-charging capability\n- Zero emissions\n- Instant torque for quick acceleration\n- Ideal for environmentally conscious longer trips"],
                    ['title' => 'Compact Electric Car for City Exploration', 'description' => "Easy to maneuver and park\n- Low running costs\n- Funky, modern design\n- Regenerative braking for extended range\n- Perfect for urban adventures and short trips"],
                    ['title' => 'High-Performance Electric Sports Sedan', 'description' => "Exhilarating acceleration\n- Advanced autopilot features\n- Futuristic interior with large touchscreen\n- Over-the-air updates\n- Great for tech enthusiasts and performance lovers"],
                    ['title' => 'Practical Electric Crossover Rental', 'description' => "Versatile interior space\n- Good ground clearance\n- Family-friendly features\n- Long range for an SUV\n- Suitable for eco-conscious families and outdoor enthusiasts"]
                ]
            ],

            'Specialty Vehicles' => [
                'Off-road Vehicles' => [
                    ['title' => 'Rugged 4x4 for Extreme Adventure', 'description' => "High ground clearance\n- Advanced 4WD system\n- Snorkel for water crossings\n- Winch for self-recovery\n- Perfect for challenging off-road expeditions"],
                    ['title' => 'Family-Friendly Off-Road SUV', 'description' => "Spacious interior for 5\n- Roof rack for gear\n- All-terrain tires\n- Easy-to-use 4x4 system\n- Ideal for family outdoor adventures"],
                    ['title' => 'Rock Crawling Specialist Vehicle', 'description' => "Extreme articulation suspension\n- Heavy-duty skid plates\n- Locking differentials\n- Beadlock wheels\n- Designed for serious rock crawling enthusiasts"],
                    ['title' => 'Overland-Ready Adventure Vehicle', 'description' => "Roof-top tent included\n- Solar panel and auxiliary battery\n- Long-range fuel tank\n- Built-in refrigerator\n- Great for extended overland trips and camping"]
                ],
                'Convertibles' => [
                    ['title' => 'Sleek Sports Convertible for Summer Fun', 'description' => "Quick-retracting soft top\n- Powerful engine for spirited driving\n- Wind deflector for comfortable cruising\n- Premium sound system\n- Perfect for scenic coastal drives"],
                    ['title' => 'Luxury 4-Seater Convertible', 'description' => "Spacious enough for four adults\n- Hardtop convertible for all-season use\n- High-end interior materials\n- Neck-level heating for chilly days\n- Ideal for group trips and special occasions"],
                    ['title' => 'Classic American Muscle Convertible', 'description' => "Iconic V8 engine sound\n- Retro-styled interior\n- Modern infotainment system\n- Easy-to-use manual top\n- Great for nostalgic drives and car enthusiasts"],
                    ['title' => 'Eco-Friendly Electric Convertible', 'description' => "Silent, emission-free driving\n- Innovative removable roof panel\n- Long electric range\n- Cutting-edge technology features\n- Perfect for environmentally conscious open-air driving"]
                ],
                'Classic Cars' => [
                    ['title' => '1960s American Muscle Car', 'description' => "Restored to original specifications\n- Powerful V8 engine\n- Classic chrome details\n- Vintage radio with Bluetooth\n- Ideal for car shows and nostalgic cruising"],
                    ['title' => 'Elegant 1950s European Sports Car', 'description' => "Timeless design\n- Leather interior with patina\n- Wire wheels\n- Updated with modern reliability features\n- Perfect for weddings and photoshoots"],
                    ['title' => 'Iconic 1980s Japanese Sports Coupe', 'description' => "Pop-up headlights\n- Original cassette player\n- Retro digital dashboard\n- Well-maintained mechanicals\n- Great for reliving 80s nostalgia"],
                    ['title' => 'Vintage 1970s Off-Road Vehicle', 'description' => "Rugged 4x4 capability\n- Removable top and doors\n- Simple, reliable mechanics\n- Restored to original paint color\n- Suitable for classic off-road adventures"]
                ],
                'Wheelchair Accessible Vehicles' => [
                    ['title' => 'Spacious Wheelchair Van with Rear Entry', 'description' => "Wide rear ramp for easy access\n- Lowered floor for ample headroom\n- Secure wheelchair tie-downs\n- Seating for additional passengers\n- Ideal for family trips and daily use"],
                    ['title' => 'Luxury Sedan with Wheelchair Accessibility', 'description' => "Smooth-operating side entry\n- Transfer seat for flexibility\n- High-end interior finishes\n- Advanced adaptive driving controls\n- Perfect for business travel and special occasions"],
                    ['title' => 'Compact Wheelchair Accessible Vehicle', 'description' => "Lightweight wheelchair ramp\n- Easy to maneuver in city traffic\n- Fuel-efficient engine\n- Flexible seating configurations\n- Great for urban living and short trips"],
                    ['title' => 'Large Capacity Wheelchair Accessible SUV', 'description' => "Multiple wheelchair positions\n- Plenty of space for equipment\n- Comfortable ride with adaptive suspension\n- Rear and side entry options\n- Suitable for group outings and extended trips"]
                ]
            ],
            'Commercial Vehicles' => [
                'Box Trucks' => [
                    ['title' => '16ft Box Truck for Local Moves', 'description' => "Easy-to-drive size\n- Fuel-efficient diesel engine\n- Liftgate for heavy items\n- Non-CDL required\n- Perfect for small business deliveries and studio apartment moves"],
                    ['title' => 'High-Cube 26ft Box Truck', 'description' => "Massive 1,600 cu. ft. cargo space\n- Air ride suspension for smooth transport\n- Logistics tracking system\n- Aluminum construction for lighter weight\n- Ideal for long-distance moves and large inventory transport"],
                    ['title' => 'Refrigerated Box Truck for Food Transport', 'description' => "Reliable cooling system\n- Easy-to-clean interior\n- Multiple temperature zones\n- Fuel-efficient operation\n- Great for catering businesses and food delivery services"],
                    ['title' => 'Economy 12ft Box Truck', 'description' => "Great fuel economy\n- Easy to maneuver in tight spaces\n- Low loading deck height\n- Comfortable cab with modern amenities\n- Suitable for small moves and local deliveries"]
                ],
                'Flatbed Trucks' => [
                    ['title' => 'Heavy Duty Flatbed with Gooseneck Hitch', 'description' => "25,000 lb towing capacity\n- Durable steel deck\n- Multiple tie-down points\n- Powerful diesel engine\n- Ideal for hauling heavy equipment and materials"],
                    ['title' => 'Compact Flatbed for Urban Deliveries', 'description' => "Nimble in city traffic\n- Easy to load from all sides\n- Fuel-efficient gas engine\n- Comfortable cab for all-day driving\n- Perfect for urban construction and landscaping projects"],
                    ['title' => 'Extendable Flatbed for Long Loads', 'description' => "Extends up to 48 feet\n- Sliding axles for weight distribution\n- Sturdy oak deck\n- Air ride suspension\n- Great for transporting lumber, pipes, and other long materials"],
                    ['title' => 'Flatbed with Crane Attachment', 'description' => "Built-in knuckle boom crane\n- Stable outriggers\n- Remote-controlled operation\n- Spacious flatbed area\n- Suitable for self-loading and unloading heavy items"]
                ],
                'Refrigerated Trucks' => [
                    ['title' => 'Small Refrigerated Van for Local Deliveries', 'description' => "Efficient cooling system\n- Easy-to-use temperature controls\n- Hygienic, easy-clean interior\n- Good fuel economy\n- Ideal for florists, pharmacies, and small catering businesses"],
                    ['title' => 'Large Capacity Refrigerated Truck', 'description' => "Multi-temperature zones\n- State-of-the-art cooling technology\n- GPS temperature monitoring\n- Spacious 26ft box\n- Perfect for long-haul food transport and large-scale catering"],
                    ['title' => 'Freezer Truck for Ice Cream and Frozen Goods', 'description' => "Capable of deep freeze temperatures\n- Rapid temperature pull-down\n- Robust insulation\n- Low-temperature lubricants for reliability\n- Great for ice cream trucks and frozen food distribution"],
                    ['title' => 'Refrigerated Box Truck with Liftgate', 'description' => "2,000 lb capacity liftgate\n- Reliable refrigeration unit\n- Adjustable shelving\n- Fuel-efficient operation\n- Suitable for mixed temperature goods and easy loading/unloading"]
                ],
                'Moving Trucks' => [
                    ['title' => '15ft Moving Truck for Small Moves', 'description' => "Easy to drive and park\n- Fuel-efficient V6 engine\n- Low deck height for easy loading\n- Equipped with furniture pads and dolly\n- Perfect for studio and small apartment moves"],
                    ['title' => 'Large 26ft Moving Truck with Auto Transport', 'description' => "Spacious for 3-4 bedroom homes\n- Car carrier trailer included\n- Air-ride suspension for smooth transport\n- Reliable diesel engine\n- Ideal for long-distance moves with a vehicle"],
                    ['title' => 'Premium Moving Truck with Loading Ramp', 'description' => "Gentle slope ramp for easy loading\n- Comfortable air-conditioned cab\n- Equipped with GPS navigation\n- Ample tie-downs and load-securing features\n- Great for DIY movers wanting comfort and convenience"],
                    ['title' => 'Eco-Friendly Hybrid Moving Van', 'description' => "Fuel-efficient hybrid powertrain\n- Suitable for in-town moves\n- Low emission for urban areas\n- Quiet operation for residential areas\n- Perfect for environmentally conscious local moves"]
                ]
            ],
            'Recreational Vehicles' => [
                'Motorhomes' => [
                    ['title' => 'Luxurious Class A Motorhome for Ultimate Comfort', 'description' => "Spacious 35ft length\n- Full kitchen with residential appliances\n- King-size master bedroom\n- Multiple slide-outs for extra space\n- Perfect for luxury long-term travel"],
                    ['title' => 'Compact Class C Motorhome for Easy Driving', 'description' => "Manageable 25ft length\n- Sleeps up to 6 people\n- User-friendly for first-time RVers\n- Fuel-efficient design\n- Ideal for family vacations and weekend getaways"],
                    ['title' => 'Fully-Equipped Class B Camper Van', 'description' => "Easy to drive and park\n- Comfortable bed for two\n- Kitchenette and wet bath\n- Solar panels for off-grid camping\n- Great for adventurous couples and solo travelers"],
                    ['title' => 'Luxury Diesel Pusher Motorhome', 'description' => "Powerful rear diesel engine\n- High-end interior finishes\n- Full-size washer and dryer\n- Advanced entertainment system\n- Suitable for full-time RV living in style"]
                ],
                'Campervans' => [
                    ['title' => 'Compact Campervan for Adventurous Couples', 'description' => "Efficient use of space\n- Comfortable bed for two\n- Basic kitchen setup\n- Easy to maneuver in cities\n- Perfect for spontaneous weekend trips"],
                    ['title' => 'High-Top Campervan with Standing Room', 'description' => "Full standing height interior\n- Versatile bed-to-seating conversion\n- Ample storage space\n- Roof vent for ventilation\n- Ideal for longer trips with more comfort"],
                    ['title' => '4x4 Off-Road Capable Campervan', 'description' => "Rugged all-wheel drive system\n- Increased ground clearance\n- Durable exterior features\n- Compact off-grid setup\n- Great for backcountry exploration and camping"],
                    ['title' => 'Eco-Friendly Electric Campervan', 'description' => "All-electric powertrain\n- Solar panel roof for auxiliary power\n- Efficient climate control system\n- Modern, sustainable interior materials\n- Suitable for environmentally conscious travelers"]
                ],
                'Travel Trailers' => [
                    ['title' => 'Lightweight Travel Trailer for Easy Towing', 'description' => "Under 3,500 lbs for most SUVs\n- Sleeps up to 4 people\n- Full bathroom and kitchen\n- Large awning for outdoor living\n- Ideal for families new to RVing"],
                    ['title' => 'Spacious Bunkhouse Travel Trailer', 'description' => "Separate bunkroom for kids\n- Master bedroom for parents\n- Full-size kitchen and dining area\n- Outdoor kitchen feature\n- Perfect for large families or group trips"],
                    ['title' => 'Rugged Off-Road Capable Travel Trailer', 'description' => "Reinforced frame and suspension\n- All-terrain tires\n- Solar power setup\n- Plenty of ground clearance\n- Great for camping in remote locations"],
                    ['title' => 'Luxury Travel Trailer with Home-Like Amenities', 'description' => "Residential-style furniture\n- Fireplace and large TV\n- Full-size refrigerator and oven\n- Spacious bathroom with glass shower\n- Suitable for those wanting premium features in a towable package"]
                ],
                'Fifth Wheels' => [
                    ['title' => 'Spacious Fifth Wheel with Multiple Slide-Outs', 'description' => "Over 400 sq ft of living space\n- Separate living and bedroom areas\n- Full-size kitchen with island\n- Washer and dryer prep\n- Ideal for extended stays or full-time RVing"],
                    ['title' => 'Luxury Fifth Wheel with Front Living Room', 'description' => "Theater seating and large TV\n- Panoramic windows for great views\n- Chef's kitchen with premium appliances\n- King-size bed in master suite\n- Perfect for those wanting a home-like experience"],
                    ['title' => 'Toy Hauler Fifth Wheel for Adventure Enthusiasts', 'description' => "Garage area for motorcycles or ATVs\n- Convertible rear space for extra living area\n- Durable interior finishes\n- Fuel station for toys\n- Great for combining luxury living with outdoor hobbies"],
                    ['title' => 'Compact Fifth Wheel for Easier Towing', 'description' => "Under 30ft in length\n- Suitable for half-ton trucks\n- Efficient layout with all essentials\n- Easy to maneuver and park\n- Ideal for couples or small families wanting fifth wheel benefits in a smaller package"]
                ]
            ],
            'Motorcycles' => [
                'Sport Bikes' => [
                    ['title' => 'High-Performance Superbike for Track Enthusiasts', 'description' => "Powerful 1000cc engine\n- Advanced traction control\n- Aerodynamic fairings\n- Brembo brakes for superior stopping\n- Perfect for experienced riders and track days"],
                    ['title' => 'Middleweight Sport Bike for Balanced Performance', 'description' => "Agile 600cc engine\n- Comfortable ergonomics for street use\n- Modern electronics package\n- Excellent fuel efficiency\n- Ideal for both daily commutes and weekend twisties"],
                    ['title' => 'Entry-Level Sport Bike for Beginners', 'description' => "Manageable 300cc engine\n- Lightweight and easy to handle\n- ABS for added safety\n- Sporty looks with comfortable riding position\n- Great for new riders wanting a sport bike experience"],
                    ['title' => 'Sport-Touring Bike for Long-Distance Comfort', 'description' => "Powerful engine with touring capabilities\n- Adjustable windscreen and ergonomics\n- Hard saddlebags for storage\n- Advanced rider aids\n- Suitable for sport bike lovers who also enjoy long rides"]
                ],
                'Cruisers' => [
                    ['title' => 'Classic American V-Twin Cruiser', 'description' => "Iconic V-twin engine sound\n- Low seat height for easy handling\n- Wide handlebars for relaxed riding position\n- Plenty of chrome accents\n- Perfect for laid-back rides and highway cruising"],
                    ['title' => 'Metric Cruiser with Modern Technology', 'description' => "Reliable Japanese engineering\n- Liquid-cooled engine for smooth operation\n- Modern infotainment system\n- ABS and traction control\n- Ideal for riders wanting cruiser style with modern features"],
                    ['title' => 'Lightweight Urban Cruiser', 'description' => "Nimble handling for city riding\n- Fuel-efficient engine\n- Low maintenance costs\n- Customizable with many accessories\n- Great for beginners or urban commuters"],
                    ['title' => 'Power Cruiser for Performance Enthusiasts', 'description' => "High-output engine for strong acceleration\n- Sport-oriented suspension\n- Aggressive styling\n- Comfortable for longer rides\n- Suitable for experienced riders wanting cruiser looks with sportbike performance"]
                ],
                'Touring Bikes' => [
                    ['title' => 'Full-Dress Touring Motorcycle for Long-Haul Comfort', 'description' => "Large fairing for excellent wind protection\n- Spacious saddlebags and top case\n- Comfortable seating for rider and passenger\n- Advanced navigation and audio systems\n- Ideal for cross-country trips and two-up touring"],
                    ['title' => 'Adventure Touring Bike for On and Off-Road Exploration', 'description' => "Versatile for both paved and dirt roads\n- Long-travel suspension\n- Upright riding position\n- Large fuel tank for extended range\n- Perfect for riders who want to explore beyond the pavement"],
                    ['title' => 'Sport-Touring Motorcycle for Dynamic Long-Distance Riding', 'description' => "Powerful engine for spirited riding\n- Semi-active suspension for comfort and handling\n- Aerodynamic fairing with adjustable windscreen\n- Hard saddlebags with quick-release system\n- Great for enthusiasts who enjoy sporty performance on long trips"],
                    ['title' => 'Lightweight Touring Bike for Manageable Adventures', 'description' => "Middleweight engine for good balance of power and efficiency\n- Comfortable ergonomics for all-day riding\n- Basic luggage system included\n- Easy to handle for a wide range of riders\n- Suitable for beginners in touring or those preferring a lighter bike"]
                ],
                'Scooters' => [
                    ['title' => 'Compact 50cc Scooter for Urban Commutes', 'description' => "Excellent fuel economy\n- Easy to park and maneuver\n- Automatic transmission for simple operation\n- Under-seat storage for groceries or a small bag\n- Perfect for short trips and city errands"],
                    ['title' => 'Mid-Size 150cc Scooter for Versatile Use', 'description' => "Capable of highway speeds\n- Comfortable for longer rides\n- Larger wheels for better stability\n- Ample storage space\n- Ideal for commuters needing to mix city and highway riding"],
                    ['title' => 'Maxi-Scooter for Long-Distance Comfort', 'description' => "Powerful 400-650cc engine\n- Motorcycle-like stability and performance\n- Generous weather protection\n- Large storage capacity\n- Great for those wanting scooter convenience with big-bike capabilities"],
                    ['title' => 'Electric Scooter for Eco-Friendly Transportation', 'description' => "Zero emissions for green commuting\n- Low operating costs\n- Silent operation\n- Removable battery for easy charging\n- Suitable for environmentally conscious urban dwellers"]
                ]
            ],
        ];

        $subcategoryTags = [
            'Compact Sedans' => ['Fuel Efficient', 'City Driving', 'Easy Parking', 'Affordable', 'Commuter'],
            'Midsize Sedans' => ['Spacious', 'Family Friendly', 'Comfortable', 'Business', 'Long Trips'],
            'Full-size Sedans' => ['Luxury', 'Roomy', 'Powerful', 'Premium Features', 'VIP'],
            'Luxury Sedans' => ['High-End', 'Executive', 'Top-Tier', 'Chauffeur', 'Prestige'],
            'Compact SUVs' => ['Versatile', 'Urban', 'Fuel Efficient', 'Easy Parking', 'Crossover'],
            'Midsize SUVs' => ['Family', 'Spacious', 'Comfortable', 'Versatile', 'Road Trip'],
            'Full-size SUVs' => ['Large Groups', 'Towing', 'Spacious', 'Powerful', 'Family'],
            'Luxury SUVs' => ['Premium', 'High-End', 'Advanced Features', 'Prestige', 'Comfort'],
            'Minivans' => ['Family-Friendly', 'Spacious', 'Versatile', 'Comfortable', 'Easy Access'],
            'Passenger Vans' => ['Group Travel', 'Spacious', 'Comfortable', 'Versatile', 'High Capacity'],
            'Cargo Vans' => ['Storage', 'Delivery', 'Utility', 'Spacious', 'Commercial'],
            'Light Duty Trucks' => ['Versatile', 'Efficient', 'Daily Use', 'Light Towing', 'Work-Ready'],
            'Heavy Duty Trucks' => ['Powerful', 'Towing', 'Durable', 'Commercial', 'Heavy-Duty'],
            'Pickup Trucks' => ['Versatile', 'Towing', 'Utility', 'Off-Road', 'Work-Ready'],
            'Sports Cars' => ['High-Performance', 'Luxury', 'Sporty', 'Exotic', 'Thrill'],
            'Exotic Cars' => ['Luxury', 'Exclusive', 'High-End', 'Supercar', 'Prestige'],
            'Subcompact Cars' => ['Fuel-Efficient', 'City-Friendly', 'Budget', 'Easy-Parking', 'Economy'],
            'Compact Cars' => ['Efficient', 'Practical', 'Affordable', 'Daily-Driver', 'Value'],
            'Hybrid Cars' => ['Eco-Friendly', 'Fuel-Efficient', 'Green', 'Advanced-Tech', 'Low-Emission'],
            'Electric Cars' => ['Zero-Emission', 'Eco-Friendly', 'High-Tech', 'Quiet', 'Future-Ready'],
            'Off-road Vehicles' => ['4x4', 'Adventure', 'Rugged', 'All-Terrain', 'Outdoor'],
            'Convertibles' => ['Open-Top', 'Sporty', 'Summer', 'Luxury', 'Fun'],
            'Classic Cars' => ['Vintage', 'Collector', 'Nostalgic', 'Retro', 'Iconic'],
            'Wheelchair Accessible Vehicles' => ['Accessible', 'Modified', 'Inclusive', 'Adaptive', 'Mobility'],
            'Box Trucks' => ['Cargo', 'Moving', 'Delivery', 'Commercial', 'Storage'],
            'Flatbed Trucks' => ['Heavy-Duty', 'Construction', 'Transport', 'Versatile', 'Industrial'],
            'Refrigerated Trucks' => ['Temperature-Controlled', 'Perishable', 'Food Transport', 'Cold Chain', 'Fresh'],
            'Moving Trucks' => ['Relocation', 'DIY Moving', 'Residential', 'Load Space', 'Convenient'],
            'Motorhomes' => ['RV', 'Self-Contained', 'Luxury', 'Road Trip', 'Home on Wheels'],
            'Campervans' => ['Compact', 'Versatile', 'Adventure', 'Van Life', 'Self-Contained'],
            'Travel Trailers' => ['Towable', 'Camping', 'Outdoor', 'Family-Friendly', 'Vacation'],
            'Fifth Wheels' => ['Luxury', 'Spacious', 'Full-Time RVing', 'Towable', 'Home-Like'],
            'Sport Bikes' => ['Performance', 'Speed', 'Agile', 'Track-Ready', 'Sporty'],
            'Cruisers' => ['Comfortable', 'Relaxed Riding', 'Highway', 'Classic', 'Easy Rider'],
            'Touring Bikes' => ['Long-Distance', 'Comfort', 'Luggage Capacity', 'Highway', 'Two-Up Riding'],
            'Scooters' => ['Urban', 'Fuel-Efficient', 'Easy to Ride', 'Commuter', 'Convenient'],
        ];

        foreach ($adsTemplates as $mainCategory => $subCategories) {
            foreach ($subCategories as $subCategory => $ads) {
                $categoryId = DB::table('categories')->where('name->en', $subCategory)->value('id');
                $tags = $subcategoryTags[$subCategory] ?? [];

                if (!$categoryId) continue;

                foreach ($ads as $ad) {
                    $state = $faker->state;
                    $city = $faker->city;
                    $country = "United States";
                    $latitude = $faker->latitude($min = 25, $max = 49);
                    $longitude = $faker->longitude($min = -125, $max = -67);

                    $make = $vehicleMakes->random();
                    $model = $make->models->random();

                    $newAd = Ad::create([
                        'title' => $ad['title'],
                        'tags' => $tags,
                        'description' => $ad['description'],
                        'price' => $faker->numberBetween(30, 300), // Daily rental rate
                        'price_type_id' => $faker->randomElement($priceTypeIds),
                        'posted_date' => $faker->dateTimeBetween('-1 month', 'now'),
                        'user_id' => $faker->randomElement($userIds),
                        'category_id' => $categoryId,
                        'for_sale_by' => $faker->randomElement(['owner', 'business']),
                        'city' => $city,
                        'state' => $state,
                        'country' => $country,
                        'latitude' => $latitude,
                        'longitude' => $longitude,
                        'location_name' => $city,
                        'status' => 'active',
                        'make_id' => $make->id,
                        'model_id' => $model->id,
                        'availability_window' => $faker->randomElement(['All future dates', '3 months into the future', '6 months into the future', '9 months into the future']),
                        'min_trip_length' => $faker->numberBetween(1, 3),
                        'max_trip_length' => $faker->numberBetween(7, 30),
                        'transmission_id' => $faker->randomElement($vehicleTransmissions),
                        'fuel_type_id' => $faker->randomElement($vehicleFuelTypes),
                        'mileage' => $faker->numberBetween(20, 50) . ' KMPL',
                        'start_date' => $faker->dateTimeBetween('now', '+1 month'),
                        'end_date' => $faker->dateTimeBetween('+1 month', '+6 months'),
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);

                    // Add random features
                    $features = $faker->randomElements($vehicleFeatures, $faker->numberBetween(2, 4));
                    $newAd->features()->attach($features);

                    // Update the slug
                    $newAd->slug = Str::slug(Str::limit($ad['title'], 138)) . '-' . substr($newAd->id, 0, 8);
                    $newAd->save();
                }
            }
        }
    }
}
