<?php

namespace Adfox\Subscription;


use Closure;
use Filament\Contracts\Plugin;
use Filament\Navigation\NavigationGroup;
use Filament\Panel;

class SubscriptionPlugin implements Plugin
{
    /**
     * @var array<string>
     */

    final public function __construct()
    {
    }

    public static function make(): static
    {
        return app(static::class);
    }

    public function getId(): string
    {
        return 'subscription';
    }

    public function register(Panel $panel): void
    {
        if ($panel->getId() == 'admin') {
            $panel->discoverResources(
                in: __DIR__ . '/Filament/Resources',
                for: 'Adfox\\Subscription\\Filament\\Resources'
            )->discoverPages(
                    in: __DIR__ . '/Filament/Pages',
                    for: 'Adfox\\Subscription\\Filament\\Pages'
                )
                ->navigationGroups([
                    NavigationGroup::make()
                        ->label('Subscription Management')
                        ->icon('heroicon-o-calendar-days')
                ]);
        }
        if ($panel->getId() == 'app') {
            $panel->discoverResources(
                in: __DIR__ . '/Filament/App/Resources',
                for: 'Adfox\\Subscription\\Filament\\App\\Resources'
            )->discoverPages(
                    in: __DIR__ . '/Filament/App/Pages',
                    for: 'Adfox\\Subscription\\Filament\\App\\Pages'
                );
        }
    }


    public function boot(Panel $panel): void
    {
        //
    }

}
