<?php

namespace Adfox\Subscription\Jobs;

use Adfox\Subscription\Services\SubscriptionService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class HandleSubscriptionCreatedJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    
    protected $subscription;

    public function __construct($subscription)
    {
        $this->subscription = $subscription;
    }

    public function handle(SubscriptionService $subscriptionService)
    {
        $subscriptionService->handleSubscriptionCreated($this->subscription);
    }
}
