<?php

namespace Adfox\Subscription\Filament\App\Pages;

use Filament\Pages\Page;


use App\Settings\GeneralSettings;
use App\Settings\SEOSettings;
use App\Settings\StripeSettings;
use App\Settings\SubscriptionSettings;
use Livewire\Attributes\Url;
use Artesaos\SEOTools\Traits\SEOTools as SEOToolsTrait;
use Illuminate\Support\Facades\Schema;

class MySubscriptions extends Page
{
    use SEOToolsTrait;
    protected static ?string $navigationIcon = 'bill';
    protected static string $view = 'subscription::filament.app.pages.my-subscriptions';
    #[Url(as: 'ref', keep: true)]
    public $referrer = '/';
    protected static ?int $navigationSort = 4;

    public static function getNavigationLabel(): string
    {
        return __('messages.t_my_subscriptions');
    }
    public  function getTitle(): string
    {
        return __('messages.t_my_subscriptions');
    }
    /**
     * Mount the component
     */
    public function mount()
    {
        if ($this->subscriptionSettings->combine_subscriptions_and_orders) {
            redirect()->route('my-orders',['active-table'=>'subscription']);
        }
        $this->setSeoData();
        abortIfSubscriptionDisabled();
    }


    /**
     * Set SEO data
     */
    protected function setSeoData()
    {
        $generalSettings = app(GeneralSettings::class);
        $seoSettings = app(SEOSettings::class);


        $separator = $generalSettings->separator ?? '-';
        $siteName = $generalSettings->site_name ?? app_name();

        $title = __('messages.t_seo_my_subscription_page_title') . " $separator " . $siteName;
        $description = $seoSettings->meta_description;

        $this->seo()->setTitle($title);
        $this->seo()->setDescription($description);
    }

    protected function updateSubscriptionCancelStatus($record, $status)
    {
        $stripe = new \Stripe\StripeClient(app(StripeSettings::class)->secret_key);
        $stripe->subscriptions->update
        (
            $record->subscription_reference,
            ['cancel_at_period_end' => $status]
        );
    }
    public function getSubscriptionSettingsProperty()
    {
        return app(SubscriptionSettings::class);
    }
    public static function isDiscovered(): bool
    {
        return app('filament')->hasPlugin('subscription') && (Schema::hasTable('settings') &&app(SubscriptionSettings::class)->status && (!app(SubscriptionSettings::class)->combine_subscriptions_and_orders));
    }
}
