<div class="">
    <header x-data="{ isSticky: false }"
        class=" bg-white  dark:bg-gray-900 shadow-sm ring-1 ring-gray-950/5 dark:ring-white/10 classic:ring-black"
        :class="{ 'sticky top-0 z-10 ': isSticky }" @scroll.window="isSticky = (window.pageYOffset > 30)">
        <div class="lg:w-2/3 md:w-3/4 mx-auto px-5">
            <div class=" flex justify-between items-center py-4">
                <div class="flex items-center gap-x-2" wire:click="redirectBack()">
                    <x-icon-arrow-left-1 class="w-6 h-6 cursor-pointer rtl:scale-x-[-1]" />
                    <h2 class="md:text-xl text-lg font-semibold">
                        {{ __('messages.t_promote_ad') }}
                    </h2>
                </div>

                @if($promotionType=='multiple')
                <x-button.primary class="min-w-[6rem] w-full md:w-auto" wire:click="$dispatch('proceed-payment')">
                    <x-loading-animation wire:target="$dispatch('proceed-payment')" />{{
                    __('messages.t_proceed_with_payment') }}</x-button.secondary>
                    @endif
                    @if($promotionType=='apply')
                    <x-button.primary class="min-w-[6rem] w-full md:w-auto" wire:click="$dispatch('validate-fields')">
                        <x-loading-animation wire:target="$dispatch('validate-fields')" />{{
                        __('messages.t_apply_plan') }}</x-button.secondary>
                        @endif
            </div>
        </div>
    </header>
    <div class="lg:w-2/3 md:w-3/4 mx-auto px-4 pt-6 pb-20 md:pb-6">
        <livewire:dynamic-component :is="$current" :key="$current" :$id :$selectedAdSlugs :$availablePlanPromotions
            :$promotionType :$selectedPromotions :$promotions />


    </div>
</div>
