<?php

namespace Adfox\Razorpay;

use Filament\Panel;
use Filament\Contracts\Plugin;

class RazorpayPlugin implements Plugin
{
    public function getId(): string
    {
        return 'razorpay';
    }

    public function register(Panel $panel): void
    {
        if ($panel->getId() == 'admin') {
            $panel->discoverResources(
                in: __DIR__ . '/Filament/Resources',
                for: 'Adfox\\Razorpay\\Filament\\Resources'
            )->discoverPages(
                    in: __DIR__ . '/Filament/Pages',
                    for: 'Adfox\\Razorpay\\Filament\\Pages'
                );
        }
    }

    public function boot(Panel $panel): void
    {
    }
}
