<?php
namespace Adfox\Paystack\Filament\Pages;

use App\Settings\PaystackSettings;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;
use App\Models\SettingsProperty;
use Filament\Forms\Components\Placeholder;
use Illuminate\Support\Facades\Config;

class PaystackPayment extends SettingsPage
{
    protected static ?string $title = 'Paystack Settings';

    protected static ?string $navigationGroup = 'Payment Gateways';

    protected static ?string $navigationLabel = 'Paystack';

    protected static ?string $slug = 'manage-paystack-settings';

    protected static string $settings = PaystackSettings::class;

    protected static ?int $navigationSort = 21; // Adjust the sort order as needed

    protected function mutateFormDataBeforeSave(array $data): array
    {
        $previousData = app(PaystackSettings::class);
        $filtered = [];

        foreach ($data as $key => $item) {
            if (property_exists($previousData, $key)) {
                $propertyType = gettype($previousData->$key);

                if (is_null($item) && $propertyType === 'string') {
                    $filtered[$key] = '';
                    continue;
                }
            }
            $filtered[$key] = $item;
        }
        return $filtered;
    }

    public function form(Form $form): Form
    {
        $paystackCurrencies=[
            'NGN'=>'Nigerian Naira',
            'USD'=>'United States Dollar',
            'GHS'=>'Ghanaian Cedi',
            'ZAR'=>'South African Rand',
            'KES'=>'Kenyan Shilling'
        ];
        $isDemo = Config::get('app.demo');

        return $form
            ->schema([
                TextInput::make('name')
                    ->label('Paystack Name')
                    ->required()
                    ->helperText('Name of the Paystack configuration.'),

                Toggle::make('status')
                    ->label('Enable Paystack')
                    ->helperText('Toggle to enable or disable Paystack integration.'),

                Select::make('currency')
                    ->label('Default Currency')
                    ->options($paystackCurrencies)
                    ->required()
                    ->helperText('Default currency for Paystack transactions.'),

                $isDemo ?
                Placeholder::make('public_key')
                    ->label('Paystack Public Key')
                    ->content('*****')
                    ->hint('Hidden due to demo mode.') :
                TextInput::make('public_key')
                    ->label('Paystack Public Key')
                    ->required()
                    ->helperText('Your Paystack Public Key.'),

                $isDemo ?
                Placeholder::make('secret_key')
                    ->label('Paystack Secret Key')
                    ->content('*****')
                    ->hint('Hidden due to demo mode.') :
                TextInput::make('secret_key')
                    ->label('Paystack Secret Key')
                    ->required()
                    ->helperText('Your Paystack Secret Key.'),

                TextInput::make('exchange_rate')
                    ->label('Exchange Rate')
                    ->numeric()
                    ->required()
                    ->helperText('Exchange rate for currency conversion.')
            ])
            ->columns(2);
    }
}
