<?php

namespace Adfox\Paypal\Livewire;

use App\Models\WebhookPackage;
use Livewire\Component;
use App\Models\WebhookUpgrade;
use App\Settings\PaymentSettings;
use App\Settings\PaypalSettings;

class PaypalPayment extends Component
{

    public $id;

    public $type;

    public $tax;

    public $data;

    public $subtotal;

    public $total;

    public $payment_gateway_params = [];

     /**
     * Mount the component and set the properties if an ad ID is provided.
     */
    public function mount($id)
    {
        $this->id = $id;
        $this->processPayment();
    }

    public function getPaymentSettingsProperty()
    {
        return app(PaymentSettings::class);
    }

    public function getPaypalSettingsProperty()
    {
        return app(PaypalSettings::class);
    }

    public function processPayment()
    {

        // Generate order id for PayPal
        $order_id = $this->type . '-' . uid(18);

        // Set PayPal payment parameters
        $this->payment_gateway_params['order_id'] = $order_id;


        $this->handleWebhookUpgrade($order_id);

    }

    protected function handleWebhookUpgrade($order_id)
    {
        try {
            if($this->type == 'PKG') {
                WebhookPackage::create([
                    'data' => json_encode($this->data),
                    'payment_id' => $order_id,
                    'payment_method' => 'paypal',
                    'status' => 'pending'
                ]);
            } else {
                WebhookUpgrade::create([
                    'data' => json_encode($this->data),
                    'payment_id' => $order_id,
                    'payment_method' => 'paypal',
                    'status' => 'pending'
                ]);
            }
        } catch (\Throwable $th) {
            // Handle any exceptions
        }
    }


    /**
     * Render the component view.
     *
     * @return \Illuminate\View\View The view to render.
     */
    public function render()
    {
        return view('paypal::paypal-payment');
    }
}
