<?php

namespace Adfox\Packages\Filament\Resources;

use Adfox\Packages\Filament\Resources\OrderPackageResource\Pages;
use Adfox\Packages\Filament\Resources\OrderPackageResource\RelationManagers;
use App\Models\OrderPackage;
use App\Models\OrderPackageItem;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Columns\SelectColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Tables\Grouping\Group;

class OrderPackageResource extends Resource
{
    protected static ?string $model = OrderPackageItem::class;

    protected static ?string $modelLabel = 'Orders';

    protected static ?string $navigationGroup = 'Package Management';

    protected static ?string $navigationLabel = 'Orders';

    protected static ?int $navigationSort = 2;

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                //
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->groups([
                Group::make('orderPackage.id')
                ->label('Order ID')
                ->getDescriptionFromRecordUsing(
                    function (OrderPackageItem $record): string {
                        return 'User Name: ' . $record->orderPackage->user->name .
                               ', User ID: ' . $record->orderPackage->user->id .
                               ', Payment Method: ' . ucfirst($record->orderPackage->payment_method) .
                               ', Taxes: ' . $record->orderPackage->taxes_value .
                               ', Subtotal: ' . $record->orderPackage->subtotal_value .
                               ', Total: ' . $record->orderPackage->total_value;
                    }
                )
            ])
            ->defaultGroup('orderPackage.id')
            ->modifyQueryUsing(fn (Builder $query) => $query->latest())
            ->columns([
                TextColumn::make('name')->label(__('Package Name')),
                TextColumn::make('activation_date')->label(__('Activation Date'))->date(),
                TextColumn::make('expiry_date')->label(__('Expiry Date'))->date(),
                TextColumn::make('price')->label(__('Price')),
                TextColumn::make('purchased')->label(__('Purchased')),
                TextColumn::make('available')->label(__('Available')),
                TextColumn::make('used')->label(__('Used')),
                TextColumn::make('orderPackage.created_at')
                    ->label('Date')
                    ->date(),
                SelectColumn::make('orderPackage.status')->options([
                        'completed' => 'Completed',
                        'pending' => 'Pending',
                        'failed' => 'Failed',
                        'refunded' => 'Refunded',
                    ]),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListOrderPackages::route('/'),
        ];
    }
}
